
-- interface
-- data Expr
one :: Expr
plus :: Expr -> Expr -> Expr

-- deep embedding
data Expr = One | Add Expr Expr
            deriving (Show)
one = One
plus = Add
eval One = 1
eval (Add e1 e2) = eval e1 + eval e2

text :: Expr -> String
text One = "1"
text (Add e1 e2) = "(" ++ text e1 ++ " + " ++ text e2 ++ ")"

treeI :: Int -> Expr
treeI 0 = one
treeI n = let shared = treeI (n-1) in shared `plus` shared
-- shared now is a term, not an Int
-- evaluating destroys the sharing introduced by let 

main = do
    putStrLn $ show $ eval $ one
    putStrLn $ show $ eval $ one `plus` one
    putStrLn $ show $ eval $ treeI 4
    putStrLn $ text $ treeI 4
    putStrLn $ show $ eval $ treeI 23 -- slow


