
-- interface
-- data Expr
one :: Expr
plus :: Expr -> Expr -> Expr

-- shallow embedding
type Expr = Int
one = 1
plus = (+)
eval = id

treeI :: Int -> Expr
treeI 0 = one
treeI n = let shared = treeI (n-1) in shared `plus` shared

-- text :: Expr -> String
-- no way to do it with shallow embedding

main = do
	putStrLn $ show $ eval $ one
	putStrLn $ show $ eval $ one `plus` one
	putStrLn $ show $ eval $ treeI 4
	putStrLn $ show $ eval $ treeI 23 -- pretty fast
