{-# LANGUAGE RankNTypes #-}

data Expr a = Lit Int
            | Add (Expr a) (Expr a)
            | IfZero (Expr a) (Expr a) (Expr a)
            | Var a
            | Let (Expr a) (a -> Expr a)
            | Lam (a -> Expr a)
            | App (Expr a) (Expr a)
            | Mu (a -> Expr a)
            | LetRec ([a] -> [Expr a]) ([a] -> Expr a)

type ClosedExpr = forall a. Expr a

n k = Lit k
plus = Add
apply = App
let_ e1 e2 = Let e1 (\x -> e2 (Var x))
lam_ e = Lam (\x -> e (Var x))
mu_ e = Mu (\x -> e (Var x))
letrec_ es e = LetRec (\xs -> es (map Var xs)) (\xs -> e (map Var xs))

data Value = N Int | F (Value -> Value)
instance Show Value where
    show (N n) = show n
    show (F _) = "fun"

eval :: Expr Value -> Value
eval (Lit n) = N n
eval (Add e1 e2) = add (eval e1) (eval e2)
eval (IfZero e1 e2 e3) = ifZero (eval e1) (eval e2) (eval e3)
eval (Var x) = x
eval (Let e1 e2) = eval (e2 (eval e1))
eval (Lam e) = F (\v -> eval (e v))
eval (App e1 e2) = app (eval e1) (eval e2)
eval (Mu e) = fix (\v -> eval (e v))
eval (LetRec es e) = let rs = map eval (es rs) in eval (e rs)

add (N m) (N n) = N (m + n)
ifZero (N n) v1 v2 = if n == 0 then v1 else v2
app (F f) v = f v
fix :: (a -> a) -> a
fix f = let r = f r in r

ex1_hs = let
          dec x = x - 1
          even x t e = if x == 0 then t else odd (dec x) t e
          odd x t e = if x == 0 then e else even (dec x) t e
        in even 4 1 0

ex1_edsl = letrec_ (\ ~[dec,even,odd] ->
            [lam_ (\x -> x `plus` Lit (-1)),
             lam_ (\x -> lam_ (\t -> lam_ (\e ->
                IfZero x t (odd `apply` (dec `apply` x) `apply` t `apply` e)
              ))),
             lam_ (\x -> lam_ (\t -> lam_ (\e ->
                IfZero x e (even `apply` (dec `apply` x) `apply` t `apply` e)
              )))
            ])
            (\ [dec,even,odd] -> even `apply` Lit 4 `apply` Lit 1 `apply` Lit 0)

ex2_hs = let
          dec x = x - 1
          even x t e = if x == 0 then t else odd (dec x) t e
          odd x t e = if x == 0 then e else even (dec x) t e
        in even 7 1 0

ex2_edsl = letrec_ (\ ~[dec,even,odd] ->
            [lam_ (\x -> x `plus` Lit (-1)),
             lam_ (\x -> lam_ (\t -> lam_ (\e ->
                IfZero x t (odd `apply` (dec `apply` x) `apply` t `apply` e)
              ))),
             lam_ (\x -> lam_ (\t -> lam_ (\e ->
                IfZero x e (even `apply` (dec `apply` x) `apply` t `apply` e)
              )))
            ])
            (\ [dec,even,odd] -> even `apply` Lit 7 `apply` Lit 1 `apply` Lit 0)

main = do
      putStrLn $ show $ ex1_hs
      putStrLn $ show $ eval $ ex1_edsl
      putStrLn $ show $ ex2_hs
      putStrLn $ show $ eval $ ex2_edsl

