import Data.Map as Map
import Control.Monad.State

newtype Person = Person { name :: String } deriving (Eq, Ord, Show)

spent payer money = modify $ insertWith (+) payer money

gave lender borrower money = modify $
    (adjust (+ money) lender) . (adjust (subtract money) borrower)

solve :: Map Person Int -> [String]
solve st = solve' err $ Map.map (\m -> m - avg) st
    where
        err = 1 + size st
        avg = round $ (toRational $ fold (+) 0 st) / (toRational $ size st)

solve' _ st | Map.null st = []
solve' err st =
    (name payer ++ " pays " ++ show amount ++ " to " ++ name receiver) : solve' err newstate
    where
        (payer, debt) = foldrWithKey (getpers True) (Person "", 0) st
        (receiver, credit) = foldrWithKey (getpers False) (Person "", 0) st
        getpers True p m (_, m0) | m < m0 = (p, m) -- Gets payer
        getpers False p m (_, m0) | m > m0 = (p, m) -- Gets receiver
        getpers _ _ _ e = e
        amount = min (-debt) credit
        newstate = Map.filter (\c -> c < -err || err < c) (mapWithKey statefix st)
        statefix p m | p == receiver = m - amount
        statefix p m | p == payer = m + amount
        statefix _ m = m

sharedexpenses :: State (Map Person Int) () -> Map Person Int
sharedexpenses f = execState f empty


dexter = Person "Dexter"
angel  = Person "Angel"
debra  = Person "Debra"
harry  = Person "Harry"

trip = sharedexpenses $ do
    dexter `spent` 5300
    angel  `spent` 2700
    debra  `spent`  800
    harry  `spent` 1900
    debra  `spent` 1700
    angel  `spent` 2200
    dexter `gave` harry $ 2000
    angel  `gave` debra $ 3200
    angel  `gave` harry $ 500

main = mapM_ putStrLn $ solve trip
