﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FastTetrisXNA
{
    public class Piece
    {
        public const int SIZE = 5;
        public bool[,] BlockData;

        private Piece()
        {
            BlockData = new bool[SIZE, SIZE];
        }

        public Piece( int[] r0, int[] r1, int[] r2, int[] r3, int[] r4 )
            : this()
        {
            for ( int i=0; i < r0.Length; i++ )
                BlockData[i, 0] = r0[i] == 1;
            for ( int i=0; i < r1.Length; i++ )
                BlockData[i, 1] = r1[i] == 1;
            for ( int i=0; i < r2.Length; i++ )
                BlockData[i, 2] = r2[i] == 1;
            for ( int i=0; i < r3.Length; i++ )
                BlockData[i, 3] = r3[i] == 1;
            for ( int i=0; i < r4.Length; i++ )
                BlockData[i, 4] = r4[i] == 1;
        }

        public static Piece Rotate( Piece Source )
        {
            // obrot I
            if ( Source == I_Horiz )
                return I_Vert;
            if ( Source == I_Vert )
                return I_Horiz;

            // obroty Z
            if ( Source == Z_LeftHoriz )
                return Z_LeftVert;
            if ( Source == Z_LeftVert )
                return Z_LeftHoriz;

            // obroty Z
            if ( Source == Z_RightHoriz )
                return Z_RightVert;
            if ( Source == Z_RightVert )
                return Z_RightHoriz;

            // obroty L
            if ( Source == L_L1 )
                return L_L2;
            if ( Source == L_L2 )
                return L_L3;
            if ( Source == L_L3 )
                return L_L4;
            if ( Source == L_L4 )
                return L_L1;
            if ( Source == R_L1 )
                return R_L2;
            if ( Source == R_L2 )
                return R_L3;
            if ( Source == R_L3 )
                return R_L4;
            if ( Source == R_L4 )
                return R_L1;

            return Box;
        }

        private static Random _r = new Random();
        public static Piece GetRandomPiece()
        {
            switch ( _r.Next( 6 ) )
            {
                case 1:
                    return Piece.Z_LeftHoriz;
                case 2:
                    return Piece.Z_RightHoriz;
                case 3:
                    return Piece.L_L1;
                case 4:
                    return Piece.R_L1;
                case 5:
                    return Piece.I_Horiz;

                default:
                    return Piece.Box;
            }
        }

        #region Block set

        #region Box

        private static Piece _box;
        public static Piece Box
        {
            get
            {
                if ( _box == null )
                {
                    _box = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 1, 1, 0, 0 },
                        new int[] { 0, 1, 1, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _box;
            }
        }

        #endregion

        #region I

        private static Piece _i_horiz;
        public static Piece I_Horiz
        {
            get
            {
                if ( _i_horiz == null )
                {
                    _i_horiz = new Piece(
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _i_horiz;
            }
        }

        private static Piece _i_vert;
        public static Piece I_Vert
        {
            get
            {
                if ( _i_vert == null )
                {
                    _i_vert = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 1, 1, 1, 1 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _i_vert;
            }
        }

        #endregion

        #region Z left

        private static Piece _z_lefthoriz;
        public static Piece Z_LeftHoriz
        {
            get
            {
                if ( _z_lefthoriz == null )
                {
                    _z_lefthoriz = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 1, 1, 0, 0 },
                        new int[] { 0, 0, 1, 1, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _z_lefthoriz;
            }
        }

        private static Piece _z_leftvert;
        public static Piece Z_LeftVert
        {
            get
            {
                if ( _z_leftvert == null )
                {
                    _z_leftvert = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 1, 1, 0, 0 },
                        new int[] { 0, 1, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _z_leftvert;
            }
        }

        #endregion

        #region Z right

        private static Piece _z_righthoriz;
        public static Piece Z_RightHoriz
        {
            get
            {
                if ( _z_righthoriz == null )
                {
                    _z_righthoriz = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 1, 1, 0 },
                        new int[] { 0, 1, 1, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _z_righthoriz;
            }
        }

        private static Piece _z_rightvert;
        public static Piece Z_RightVert
        {
            get
            {
                if ( _z_rightvert == null )
                {
                    _z_rightvert = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 1, 1, 0 },
                        new int[] { 0, 0, 0, 1, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _z_rightvert;
            }
        }

        #endregion

        #region L left

        private static Piece _l_l1;
        public static Piece L_L1
        {
            get
            {
                if ( _l_l1 == null )
                {
                    _l_l1 = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 1, 0, 0, 0 },
                        new int[] { 0, 1, 1, 1, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _l_l1;
            }
        }

        private static Piece _l_l2;
        public static Piece L_L2
        {
            get
            {
                if ( _l_l2 == null )
                {
                    _l_l2 = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 1, 1, 0, 0 },
                        new int[] { 0, 1, 0, 0, 0 },
                        new int[] { 0, 1, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _l_l2;
            }
        }

        private static Piece _l_l3;
        public static Piece L_L3
        {
            get
            {
                if ( _l_l3 == null )
                {
                    _l_l3 = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 1, 1, 1, 0, 0 },
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _l_l3;
            }
        }

        private static Piece _l_l4;
        public static Piece L_L4
        {
            get
            {
                if ( _l_l4 == null )
                {
                    _l_l4 = new Piece(
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 1, 1, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _l_l4;
            }
        }

        #endregion

        #region L right

        private static Piece _r_l1;
        public static Piece R_L1
        {
            get
            {
                if ( _r_l1 == null )
                {
                    _r_l1 = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 1, 0 },
                        new int[] { 0, 1, 1, 1, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _r_l1;
            }
        }

        private static Piece _r_l2;
        public static Piece R_L2
        {
            get
            {
                if ( _r_l2 == null )
                {
                    _r_l2 = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 1, 1, 0 },
                        new int[] { 0, 0, 0, 1, 0 },
                        new int[] { 0, 0, 0, 1, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _r_l2;
            }
        }

        private static Piece _r_l3;
        public static Piece R_L3
        {
            get
            {
                if ( _r_l3 == null )
                {
                    _r_l3 = new Piece(
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 1, 1, 1 },
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _r_l3;
            }
        }

        private static Piece _r_l4;
        public static Piece R_L4
        {
            get
            {
                if ( _r_l4 == null )
                {
                    _r_l4 = new Piece(
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 1, 0, 0 },
                        new int[] { 0, 0, 1, 1, 0 },
                        new int[] { 0, 0, 0, 0, 0 },
                        new int[] { 0, 0, 0, 0, 0 } );
                }

                return _r_l4;
            }
        }

        #endregion

        #endregion
    }
}
