/* iterate.c */

#include "private.h"

void BrepIterate(BREP_RING *first, void (*func)(BREP_RING *))
{
  BREP_RING *ring, *next;

  if (first) {
    next = first;
    do {
      ring = next;
      next = ring->next;
      func(ring);
    } while (next != first);
  }  
}

void BrepIterate1A(BREP_RING *first, void (*func)(BREP_RING *, void *), void *parm)
{
  BREP_RING *ring, *next;

  if (first) {
    next = first;
    do {
      ring = next;
      next = ring->next;
      func(ring, parm);
    } while (next != first);
  }  
}

void BrepIterate2A(BREP_RING *first, void (*func)(BREP_RING *, void *, void *), void *parm1, void *parm2)
{
  BREP_RING *ring, *next;

  if (first) {
    next = first;
    do {
      ring = next;
      next = ring->next;
      func(ring, parm1, parm2);
    } while (next != first);
  }  
}

