
#ifndef COEFFICIENT_STREAM_H
#define COEFFICIENT_STREAM_H

#include "color.h"

class CoefficientStore
{
private:
  int          nnc;
  unsigned int *bitmap;
  COLOR        *coefs;

public:
  CoefficientStore(const int nt,const int nc);
  ~CoefficientStore();

  // Size in bytes required
  int getNumBytes();

  friend class CoefficientStream;
};


class CoefficientStream
{
private:
  CoefficientStore     *cs;
  COLOR                *curcoef;
  unsigned int         *curbitmap;
  unsigned int         val,delta;

public:
  CoefficientStream();

  void   setCoefficientStore(CoefficientStore *cs);
  
  void   startRead();
  COLOR* nextRead();

  void   startWrite();
  void   skipWrite();
  void   nextWrite(COLOR *coef);
  void   endWrite();
};

#endif
