

#include "Common.h"
#include "EmissionStrategy.h"

CombineEmissionStrategy::CombineEmissionStrategy(int n)
{
  // Save n
  nm = n;

  // Alloc space for emission strategy and probability array
  es = new EmissionStrategy* [nm];
  p = new float[nm];
}


CombineEmissionStrategy::~CombineEmissionStrategy()
{
  int i;

  // Delete contents of emission strategy array.
  for (i=0;i<nm;i++)
    {
      if (es[i] != NULL)
	delete es[i];
    }

  // Delete the array itself.
  delete es;

  // Delete probability array.
  delete p;
}


void CombineEmissionStrategy::setEmissionStrategy(int i,float np,EmissionStrategy *npb)
{
  es[i] = npb;
  p[i] = np;
}


void CombineEmissionStrategy::Update(PATCH *patch)
{
  int i;

  for (i=0;i<nm;i++)
    es[i]->Update(patch);
}


double CombineEmissionStrategy::SendRay(PATCH *patch,RAY &rout,HITREC &hout)
{
  double cosTheta;
  double res;
  float  rn;
  int    m,i;

  // Choose a method according to probability array.
  rn = drand48();
  m = 0;
  while (m < nm)
    {
      if (rn <= p[m])
	break;
      rn -= p[m];
      m++;
    }

  // Set default result
  res = 0.0;

  // A method is choosen
  if (m < nm)
    {
      // First select the ray using the choosen method.
      res = p[m] * es[m]->SendRay(patch,rout,hout);
      
      // Sometimes a method fails to choose a ray.
      if (res==0.0)
	return 0.0;

      // Check we are on the good side.
      cosTheta = VECTORDOTPRODUCT(patch->normal,rout.dir);
      if (cosTheta<0.0)
	return 0.0;

      // Combine using Eric Veach article...
      for (i=0;i<nm;i++)
	{
	  if (i != m)
	    res += p[i] * es[i]->EvalRay(patch,rout,hout);
	}
    }

  return res;
}


double CombineEmissionStrategy::EvalRay(PATCH* patch,RAY &rout,HITREC &hout)
{ 
  double res;
  int    i;

  // Initialise res.
  res = 0.0;

  // Combine using Eric Veach article...
  for (i=0;i<nm;i++)
    res += p[i] * es[i]->EvalRay(patch,rout,hout);

  return res;
}
