
#ifndef COMMON_H
#define COMMON_H

#include <math.h>

#include "color.h"
#include "spherical.h"
#include "vector.h"
#include "destP.h"


#define BIG_EPSILON   1e-3

#ifndef M_2_IPI2
#define M_2_IPI2      0.202642367285
#endif

#ifndef M_2PI
#define M_2PI         (2.0*M_PI)
#endif

#ifndef M_1_2PI
#define M_1_2PI       (1.0/M_2PI)
#endif

#ifndef M_PI_2
#define M_PI_2        (M_PI*0.5)
#endif

#ifndef M_2_PI
#define M_2_PI        (2.0/M_PI)
#endif

#ifndef rint
#define rint(x) floor(x+0.5)
#endif

extern DensityEstimationState   deState;
extern VECTOR                   origin;
extern COLOR                    zerorad;
extern float                    absMaxComponentColor(COLOR *c);
extern void                     vectorToSpherical(VECTOR*,COORDSYS*,double *,double *);
extern void                     RayCastingFunction(PATCH*,RAY *,HITREC&);
extern void                     RayCastingFunctionTwo(PATCH*,PATCH*,RAY *,HITREC&);
extern int                      countBits(int v);


#define TRANSFORMVECTOR(r,a,b,d)    { \
                                      (d).u = VECTORDOTPRODUCT((r),(a)); \
                                      (d).v = VECTORDOTPRODUCT((r),(b)); \
                                    }

#define VECTORTRANSFORM(s,a,b,c,d) { \
                                     (d).x = VECTORDOTPRODUCT((s),(a)); \
                                     (d).y = VECTORDOTPRODUCT((s),(b)); \
				     (d).z = VECTORDOTPRODUCT((s),(c)); \
				   }

#define COLORCOPY(a,d) { (d).r = (a).r; (d).g = (a).g; (d).b = (a).b; } 
#define RGBCOPY(e,f)  { (f).r=(e).r; (f).g=(e).g; (f).b=(e).b; }

#define IS_PATCH_EMISSION(x)  (x & (DE_AREA_EMISSION|DE_EQUI_WIN_EMISSION|DE_DIRECT_POTENTIAL_EMISSION))
#define IS_PATCH_SAMPLING(x) ((x) & (DE_AREA_SAMPLE|DE_EQUI_WIN_SAMPLE|DE_DIRECT_POTENTIAL_SAMPLE))

#define SWITCHBIT(x,y) ((x) ^ (y))
#define ISSET(x,y) ((x)&(y))


#ifdef DE_DEBUG
#define DebugAssert(a,s) if (!(a)) { fprintf(stderr,"Assertion failed in file "__FILE__ " at line %i\nError message : %s.\n",__LINE__,s); exit(0); }
#else
#define DebugAssert(a,s)
#endif

#endif













