
#ifndef COMPRESSED_COLOR_H
#define COMPRESSED_COLOR_H

#include <stdlib.h>
#include <stdio.h>
#include "color.h"


// This class is used to store radiance triples using a very compact representation.
// only 4 bytes are needed to store high dynamic RGB triples.
// See "Real Pixels", Greg Ward, Graphics Gems II, p80-83, published by Arvo, Academic Press. 

class CompressedColor
{
private:
  unsigned char  r,g,b,e;

public:
  // Constructor -- a black color.
  CompressedColor();

  // Constructor -- convert from color.
  CompressedColor(const COLOR& col);

  // set Color
  void setColor(const COLOR& col);

  // get Color
  void getColor(COLOR& col);

  // Get the size of a compressed color on disk.
  int  getSize();

  // Write a compressed color in an output stream
  void write(FILE *ff);

  // Read a compressed color from an input stream
  void read(FILE *ff);
};

#endif
