
#ifndef DYNAMIC_VECTOR_H
#define DYNAMIC_VECTOR_H


class DynamicVectorNode
{
private:
  static const int  granularity = 100;
  DynamicVectorNode *next;
  void              *elems[granularity];

public:
  DynamicVectorNode();


  friend class DynamicVector;
};



class DynamicVector
{
public:
  // Constructs a new dynamic vector.
  DynamicVector();

  // Destroy a dynamic vector.
  ~DynamicVector();
  
  // Add an element to a dynamic vector.
  int addElement(void*);

  // Get the number of elements of a dynamic vector.
  int size();
  
  // Iterate through the dynamic vector.
  void   iterateStart();
  int    iterateIsNext();
  void*  iterate();
  
  // Free all elements of a dynamic vector.
  void freeAllElements();

private:
  DynamicVectorNode       *first,*last,*current;
  int                     count,lastcount,curcount;

  // Add a new dynamic vector node.
  // OUT: FALSE if memory allocation failed.
  int addDynamicVectorNode();

};

#endif
