
#ifndef DYNAMIC_VECTOR_H
#define DYNAMIC_VECTOR_H



// DynamicVectorNode<ToStore,Granularity>
// This class is used to store Granularity pointers to ToStore objects.
// This class is not intended to the end-user of DynamicVector.
template <class ToStore,int Granularity> 
class DynamicVectorNode
{
public:
  // Constructor.
  DynamicVectorNode();

private:
  DynamicVectorNode<ToStore,Granularity>  *next;                // Pointer to the next DynamicVectorNode
  ToStore*                                elems[Granularity];   // Array of pointers to ToStore
};



template <class ToStore,int Granularity>
class DynamicVector
{
public:
  // Constructs a new dynamic vector.
  DynamicVector();

  // Destroy a dynamic vector.
  ~DynamicVector();
  
  // Add an element to a dynamic vector.
  int addElement(T*);

  // Get the number of elements of a dynamic vector.
  int size();
  
  // Iterate through the dynamic vector.
  void   iterateStart();
  int    iterateIsNext();
  T*     iterate();
  
  // Free all elements of a dynamic vector.
  void freeAllElements();



private:
  DynamicVectorNode<ToStore,Granularity>       *first,*last,*current;
  int                                          count;
  int                                          lastcount;
  int                                          curcount;

  // Add a new dynamic vector node.
  // OUT: FALSE if memory allocation failed.
  int addDynamicVectorNode();
};

#endif
