
#ifndef HEMICUBE_H
#define HEMICUBE_H

#include "camera.h"
#include "patch.h"
#include "render.h"
#include "spherical.h"
#include "vector.h"

#include "PatchProbabilityAssigner.h"


// Flags for build method of class Hemicube
typedef enum
{
  HEMICUBE_NONE, HEMICUBE_VISIBILITY, HEMICUBE_PIXEL_COUNT, HEMICUBE_FORM_FACTOR
} HemicubeType;


class Hemicube : public PatchProbabilityAssigner
{
private:
  static const int   defaultResolution = 50;         // Default resolution of a hemicube
  int                actualResolution;               // Resolution for this hemicube
  HemicubeType       ht;                             // kind of hemicube

public:
  // Constructor
  Hemicube(HemicubeType nht);
  Hemicube(HemicubeType nht,int resolution);


  // Auxiliary static method : Do an id rendering
  // IN:   The position of the camera.
  //       The delta vector to the center of the screen.
  //       The delta vector for the up direction.
  //       The delta vector for the right direction.
  //       The resolution for the buffer.
  //       The pointer to the buffer (to be allocated)
  // POST: The pointer points to an id rendering  of the scene from above parameters.
  static void doIdBuffer(VECTOR &pos,VECTOR &scd,VECTOR &upd,int res,unsigned long * &buf);

  // Virtual method of PatchProbabilityAssigner
  void recomputeProbabilities(PATCH *);
};
 
#endif





