
#include <math.h>
#include "Impact.h"
#include <Common.h>

Impact::Impact()
{}


int Impact::getNumBytes()
{
  return (2*sizeof(unsigned short) +                 // Coordinates
	  2*sizeof(unsigned short) +                 // Direction
	  4                                          // Weight
	  );
}


void Impact::setPatchId(const int pid)
{ id = pid;}


int Impact::getPatchId()
{ return id;}


void Impact::setCoordinates(const VEC2D& uv)
{
  u = (unsigned short) rint(uv.u*65535.0f);
  v = (unsigned short) rint(uv.v*65535.0f);
}


void Impact::getCoordinates(VEC2D& uv)
{
  uv.u = (float)u/65535.0f;
  uv.v = (float)v/65535.0f;
}


void Impact::setDirection(const VEC2D& phitheta)
{
  p = (unsigned short) rint(phitheta.u*65535.0f/M_2PI);
  t = (unsigned short) rint(phitheta.v*65535.0f/M_PI_2);
}


void Impact::getDirection(VEC2D& phitheta)
{
  phitheta.u = (float)p*M_2PI/65535.0f;
  phitheta.v = (float)t*M_PI_2/65535.0f;
}


void Impact::setWeight(const COLOR& col)
{
  weightRGB.setColor(col);
}


void Impact::getWeight(COLOR& col)
{
  weightRGB.getColor(col);
}



void Impact::write(FILE* ff)
{
  // Write coordinates
  fwrite((void*)(&u),sizeof(unsigned short),1,ff);
  fwrite((void*)(&v),sizeof(unsigned short),1,ff);
  
  // Write direction
  fwrite((void*)(&p),sizeof(unsigned short),1,ff);
  fwrite((void*)(&t),sizeof(unsigned short),1,ff);
  
  // Write weight
  weightRGB.write(ff);
}



void Impact::read(FILE* ff)
{
  // Read coordinates
  fread((void*)(&u),sizeof(unsigned short),1,ff);
  fread((void*)(&v),sizeof(unsigned short),1,ff);
  
  // Read direction
  fread((void*)(&p),sizeof(unsigned short),1,ff);
  fread((void*)(&t),sizeof(unsigned short),1,ff);

  // Read weight
  weightRGB.read(ff);
}



