
#include <math.h>
#include "color.h"
#include "PerceivedLuminance.h"

const float luminanceDelta  = 0.063f;
const float luminanceBottom = 1e-7f;

float perceivedLuminance(const COLOR& c)
{
  float res;

  res = ColorLuminance(c);
  if (res<luminanceBottom)
    res = luminanceBottom;
  
  return (log(res)/log(1.0f+luminanceDelta));
}
