
#ifndef SAMPLING_PROCESS_H
#define SAMPLING_PROCESS_H


#include "EmissionStrategy.h"
#include "SamplingStrategy.h"
#include "GenericDLList.h"



class SamplingStep
{
public:
  int               nApp;                // Number of application
  int               emissionFlags;       // Emission flags
  int               sampleFlags;         // Sampling flags
  double            partEnergy;          // Amount of energy
  double            partParticles;       // Amount of particles
  HemicubeType      hemiType;            // Hemicube type
  EmissionStrategy  *es;                 // Emission strategy to use
  SamplingStrategy  *ss;                 // Sampling strategy to use

  // Constructor.
  SamplingStep();
  SamplingStep(int times,int eflags,HemicubeType ht,int sflags,double pEnerg,double pPartic);
  ~SamplingStep();

  // Name this sampling step.
  char* getDescription();

  friend class SamplingProcess;
};


// This class describes the whole sampling process.
class SamplingProcess : public Vector<SamplingStep>
{
private:
  double           totEnergy;            // Sum of partEnergy
  double           totParticles;         // Sum of partParticles
  
  double           totAveragePower;

  Impact           impact;               // A particle impact

  void doStep(SamplingStep *);
  void doPatch(SamplingStep *,PATCH *,double,double);

public:
  // Constructor
  SamplingProcess();
  
  // Destructor
  ~SamplingProcess();

  // Execute the sampling process
  void doSampling();
};

#endif





