
#include "dest.h"
#include "phong.h"
#include "scene.h"
#include "Common.h"
#include "SamplingStrategy.h"
#include "PatchProbabilityAssigner.h"

SamplingStrategy* SamplingStrategy::newSamplingStrategy(int sf)
{
  CombineBRDFSamplingStrategy *ss;
  int                         cb,i;
  float                       fp;

  cb = countBits(sf);
  
  // Combine
  if (cb>1)
    {
      fp = 1.0f / (float)cb;
      i = 1 ;
      ss = new CombineBRDFSamplingStrategy(cb);
      while (cb > 0)
	{
	  if ((sf & i) !=0 )
	    {
	      cb--;
	      ss->setSamplingStrategy(cb,fp,newSingleSamplingStrategy(sf & i));
	    }
	  i <<= 1;
	}
      return ss;
    }

  // Single
  if (cb==1)
    return newSingleSamplingStrategy(sf);
   
  // Error
  return NULL;
}



SamplingStrategy* SamplingStrategy::newSingleSamplingStrategy(int sm)
{
  switch (sm)
    {
    case DE_UNIFORM_SAMPLE:
      return new UniformBRDFSamplingStrategy();

    case DE_COSTHETA_SAMPLE:
      return new CosThetaBRDFSamplingStrategy();

    case DE_BRDF_SAMPLE:
      return new PhysicalBRDFSamplingStrategy();

    case DE_AREA_SAMPLE:
      return new PatchBRDFSamplingStrategy(new AreaPatchProbabilityAssigner());

    case DE_DIRECT_POTENTIAL_SAMPLE:
      return new PatchBRDFSamplingStrategy(new DirectPotentialPatchProbabilityAssigner());

    case DE_EQUI_WIN_SAMPLE:
      return new PatchBRDFSamplingStrategy(new EquiWinPatchProbabilityAssigner());
      
    default:
      return NULL;
    }
}


void SamplingStrategy::Update()
{}





