
#include "dest.h"
#include "phong.h"
#include "scene.h"
#include "Common.h"
#include "SamplingStrategy.h"


double UniformBRDFSamplingStrategy::BounceRay(RAY &,HITREC &hin,RAY &rout,HITREC &hout)
{
  DENSITY_ESTIMATION_DATA_PTR thisData;
  double                      xi_1,xi_2,pdf;
  
  // Access density estimation data more easily
  thisData  = (DENSITY_ESTIMATION_DATA_PTR) hin.patch->radiance_data;

  // Halton sampling
  xi_1 = drand48();
  xi_2 = drand48();
	    
  // Initiate reflection ray
  rout.pos = hin.point;
  rout.dir = SampleHemisphereUniform(&(thisData->coordsys),xi_1,xi_2,&pdf);

  // Send ray
  RayCastingFunction(hin.patch,&rout,hout);

  // Probability of this ray
  return pdf;
}

double UniformBRDFSamplingStrategy::EvalRay(RAY &,HITREC &,RAY &,HITREC &,const double cosTheta)
{
  return (cosTheta<0.0) ? 0.0 : M_1_2PI;
}

