
#include "Common.h"
#include "EmissionStrategy.h"



double UniformEmissionStrategy::SendRay(PATCH *patch,RAY &rout,HITREC &hout)
{
  DENSITY_ESTIMATION_DATA_PTR data;
  double                      xi_1,xi_2,xi_3,xi_4;
  double                      pdf;
 
  // Find the data associated to the current patch
  data = (DENSITY_ESTIMATION_DATA_PTR) (patch->radiance_data);

  // Halton sampling
  xi_1 = drand48();
  xi_2 = drand48();
  xi_3 = drand48();
  xi_4 = drand48();

  // Choose the starting point
  PatchUniformPoint(patch,xi_1,xi_2,&rout.pos);
      
  // Choose the initial direction
  rout.dir = SampleHemisphereUniform(&(data->coordsys),xi_3,xi_4,&pdf);

  // Send the particle
  RayCastingFunction(patch,&rout,hout);

  return pdf;
}

double UniformEmissionStrategy::EvalRay(PATCH *,RAY &,HITREC &)
{
  return M_1_2PI;
}



