

#ifndef _DESTP_H_
#define _DESTP_H_

#include "spherical.h"

#include "EmissionStrategy.h"
#include "HemisphereScratchPad.h"
#include "ImpactStore.h"
#include "Kernel.h"
#include "SamplingProcess.h" 
#include "SamplingStrategy.h"
#include "ScratchPad.h"
#include "Surface.h"


/* Density Estimation specific patch data */
typedef struct 
{
  /* Information needed to reflect and transmit rays                                        */
  COORDSYS                       coordsys;             /* Patch coordinate system           */

  /* Information needed for fast interactive display                                        */
  Surface*                       swptr;                /* Used for detailled display */
} DENSITY_ESTIMATION_DATA, *DENSITY_ESTIMATION_DATA_PTR;


typedef enum
{
  DE_SIMPLIFY_COMPRESSION, DE_SIMPLIFY_DECIMATION
} DESimplifyMode;

typedef enum
{
  DE_PT_SIMPLE, DE_PT_ADAPTIVE, DE_PT_EXPERT
} DEParticleTracingMode;

typedef enum
{
  DE_NODIRECTION_RECONSTRUCTION, DE_UNIDIRECTION_RECONSTRUCTION, DE_MULTIDIRECTION_RECONSTRUCTION
} DEReconstructionMode;


/* Density Estimation state information */
typedef struct 
{
  /* Options                                                                                */ 
  int                            totNP;                /* Total number of particles to send */
  DEKernelShape                  kernelShape;          /* Reconstruction kernel shape       */
  DESimplifyMode                 simplifyMode;         /* Kind of simplification            */
  DEParticleTracingMode          particleTracingMode;  /* Predefined particle tracing       */
  DEReconstructionMode           directionnal;         /* Do we reconstruct 4D functions ?  */
  unsigned int                   c1;                   /* Kernel size constant              */
  unsigned int                   maxSubLevel;          /* Subdivision level to use          */
  unsigned int                   c2;                   /* Kernel size directionnal          */
  unsigned int                   maxSubLevelD;         /* Directionnal subdivision          */
  int                            edgeCompensate;       /* Do we compensate edges ?          */
  int                            largeKernel;          /* Do we process differently large kernels ? */
  float                          simplifyThreshold;    /* How much do we simplify ?         */
  
  /* Internal state variables                                                               */
  int                            inWork;               /* Are we computing ?                */
  int                            curPhase;             /* Current phase                     */
  PATCHLIST                      *curPatchList;        /* Current patch container           */
  PATCH                          *curPatch;            /* Current patch                     */

  int                            wakeUp;               /* Various timing variables          */
  long                           lastClock;            /* Last value of the clock           */
  float                          cpuParticleTracing;   /* Time spend in particle tracing    */
  float                          cpuReconstruction;    /* Time spend in reconstruction      */
  int                            bytesResult;          /* Bytes required to hold the result */

  SamplingProcess                simpleBRDFSP;         /* Simple BRDF sampling process config       */
  SamplingProcess                adaptiveEquiWinSP;    /* Adaptive equi-win sampling process config */
  SamplingProcess                expertSP;             /* Expert sampling process config            */
  HemisphereScratchPad           *hsp;                 /* Hemisphere scratchpad             */
  ScratchPad                     *spp;                 /* The scratchpad for calculations   */
  ImpactStore                    *isp;                 /* Corresponding impact store object */
} DensityEstimationState, *DensityEstimationStatePtr;



/* Private functions */
extern void                         PrintStateDensityEstimation(void);
extern void                         ShowDestControlPanel(void);
extern void                         HideDestControlPanel(void);
extern void 			    CreateDestControlPanel(void *parent_widget);

extern void                  WakeUpDensityEstimation(int);


#define DENSITY_ESTIMATION_PHASE_INITIALISATION   0
#define DENSITY_ESTIMATION_PHASE_PARTICLE_TRACING 1
#define DENSITY_ESTIMATION_PHASE_RECONSTRUCTION   2
#define DENSITY_ESTIMATION_PHASE_TERMINATION      3

#define DEFAULT_DE_TOTNP                     300000
#define DEFAULT_DE_PARTICLE_TRACING_MODE     DE_PT_SIMPLE
#define DEFAULT_DE_KERNEL_SHAPE              DE_EPANECHNIKOV_KERNEL
#define DEFAULT_DE_C1                        2000
#define DEFAULT_DE_C2                        1000
#define DEFAULT_DE_MAX_SUB_LEVEL             8
#define DEFAULT_DE_MAX_SUB_LEVEL_D           2
#define DEFAULT_DE_DIRECTIONNAL              DE_NODIRECTION_RECONSTRUCTION
#define DEFAULT_DE_EDGE_COMPENSATE           1
#define DEFAULT_DE_CORNER_COMPENSATE         1
#define DEFAULT_DE_LARGE_KERNEL              1
#define DEFAULT_DE_SIMPLIFY_MODE             DE_SIMPLIFY_COMPRESSION
#define DEFAULT_DE_SIMPLIFY_THRESHOLD        0.0

#endif














