/* 
   ui_dest.c : Density Estimation Algorithm - user interface implementation
   (c) Olivier Ceulemans, 1998.
*/
#include <math.h>

#include "ui.h"
#include "uit.h"
#include <Xm/MessageB.h>
#include <Xm/List.h>
#include <Xm/Xm.h>
#include "dest.h"
#include "destP.h"

#include "error.h"
#include "canvas.h"

#include "Common.h"

#include "ui_expert.h"

static Widget deControlPanel;
static Widget deExpertModePB;
static Boolean valid;

static void ExpertModePBSetState()
{ XtSetSensitive(deExpertModePB,(deState.particleTracingMode==DE_PT_EXPERT)); }


static void ParticleTracingModeCallback(Widget,XtPointer client_data,XtPointer call_data)
{
  int set = ((XmToggleButtonCallbackStruct *)call_data)->set;
  if (set == XmSET) 
    deState.particleTracingMode = (DEParticleTracingMode)((int)client_data);
  
  ExpertModePBSetState();
}





static void SimplificationModeCallback(Widget,XtPointer client_data,XtPointer call_data)
{
  int set = ((XmToggleButtonCallbackStruct *)call_data)->set;
  if (set == XmSET) 
    deState.simplifyMode = (DESimplifyMode)((int)client_data);
}



static void ReconstructionModeCallback(Widget,XtPointer client_data,XtPointer call_data)
{ 
  int set = ((XmToggleButtonCallbackStruct *)call_data)->set;
  if (set == XmSET) 
    deState.directionnal = (DEReconstructionMode)((int)client_data);
}


static void KernelShapeCallback(Widget,XtPointer client_data,XtPointer)
{ deState.kernelShape = (DEKernelShape)((int)client_data); }

static void EdgeCompensateCallback(Widget,XtPointer,XtPointer call_data)
{ deState.edgeCompensate = (((XmToggleButtonCallbackStruct *)call_data)->set == XmSET); }

static void LargeKernelCallback(Widget,XtPointer,XtPointer call_data)
{ deState.largeKernel = (((XmToggleButtonCallbackStruct *)call_data)->set == XmSET); }

static void DismissCallback(Widget,XtPointer,XtPointer)
{ XtUnmanageChild(deControlPanel); }

static void ExpertModePBCallback(Widget,XtPointer,XtPointer)
{ 
  ShowExpertModeControlPanel();
}

void CreateDestControlPanel(void *parent_widget)
{
  Widget  parent = (Widget)parent_widget;
  Widget  deForm ,  deForm1, deForm2, frame, subform, subsubform;
  Widget  temp,togglebox;
  
  // Create the control panel
  deControlPanel = CreateDialog(parent, "deControlPanel");
  
  deForm = CreateForm(deControlPanel,"deForm");

  // Title
  CreateLabel(deForm, "deTitle");
  
  // Two columns
  deForm1 = CreateRowColumn(deForm, "deForm1");
  deForm2 = CreateRowColumn(deForm, "deForm2");

  // Particle tracing options
  frame = CreateFrame(deForm1, "deParticleTracingFrame", "deParticleTracingTitle");

  subform = CreateRowColumn(frame, "deParticleTracingForm");

  CreateFormEntry(subform, "deNumberParticle", "deNumberParticleTextf",FET_INTEGER, (XtPointer)&deState.totNP, &valid, 0);

  CreateLabel(subform,"dePTModeTitle");

  togglebox = CreateRadioBox(subform,"dePTMode");
  CreateToggleButton(togglebox,"dePTSimple",(deState.particleTracingMode == DE_PT_SIMPLE),ParticleTracingModeCallback,(XtPointer)DE_PT_SIMPLE);
  CreateToggleButton(togglebox,"dePTAdaptive",(deState.particleTracingMode == DE_PT_ADAPTIVE),ParticleTracingModeCallback,(XtPointer)DE_PT_ADAPTIVE);
  CreateToggleButton(togglebox,"dePTExpert",(deState.particleTracingMode == DE_PT_EXPERT),ParticleTracingModeCallback,(XtPointer)DE_PT_EXPERT);
  XtManageChild(togglebox);

  deExpertModePB = CreatePushButton(subform,"deExpertModePB",ExpertModePBCallback,(XtPointer)0);
  XtManageChild(subform);


  // Reconstruction options
  frame = CreateFrame(deForm2, "deReconstructionFrame", "deReconstructionTitle");
  subform = CreateRowColumn(frame, "deReconstructionForm");
  CreateFormEntry(subform, "deC1", "deC1Textf",FET_UNSIGNED, (XtPointer)&deState.c1, &valid, 0);
  CreateFormEntry(subform, "deNumberMaxSubdivision", "deNumberMaxSubdivisionTextf",FET_UNSIGNED, (XtPointer)&deState.maxSubLevel, &valid, 0);
  CreateFormEntry(subform, "deC2", "deC2Textf",FET_UNSIGNED, (XtPointer)&deState.c2, &valid, 0);
  CreateFormEntry(subform, "deNumberMaxSubdivisionD", "deNumberMaxSubdivisionDTextf",FET_UNSIGNED, (XtPointer)&deState.maxSubLevelD, &valid, 0);
  
  CreateToggleButton(subform,"deEdgeCompensateToggle",deState.edgeCompensate,EdgeCompensateCallback,(XtPointer)0);
  CreateToggleButton(subform,"deLargeKernelToggle",deState.largeKernel,LargeKernelCallback,(XtPointer)0);

  CreateLabel(subform,"deReconstructionModeTitle");
  togglebox = CreateRadioBox(subform,"deReconstructionMode");
  CreateToggleButton(togglebox,"deNoneReconstruction",(deState.directionnal == DE_NODIRECTION_RECONSTRUCTION),ReconstructionModeCallback,(XtPointer)DE_NODIRECTION_RECONSTRUCTION);
  CreateToggleButton(togglebox,"deUniReconstruction",(deState.directionnal == DE_UNIDIRECTION_RECONSTRUCTION),ReconstructionModeCallback,(XtPointer)DE_UNIDIRECTION_RECONSTRUCTION);
  CreateToggleButton(togglebox,"deMultiReconstruction",(deState.directionnal == DE_MULTIDIRECTION_RECONSTRUCTION),ReconstructionModeCallback,(XtPointer)DE_MULTIDIRECTION_RECONSTRUCTION);
  XtManageChild(togglebox);



  subsubform = CreateOptionMenu(subform,"deKernelShapeMenu","deKernelShapeOptions");
  CreateOptionButton(subsubform,"deCylinderKernel",(deState.kernelShape == DE_CYLINDER_KERNEL),KernelShapeCallback,(XtPointer)DE_CYLINDER_KERNEL);
  CreateOptionButton(subsubform,"deConeKernel",(deState.kernelShape == DE_CONE_KERNEL),KernelShapeCallback,(XtPointer)DE_CONE_KERNEL);
  CreateOptionButton(subsubform,"deK2Kernel",(deState.kernelShape == DE_K2_KERNEL),KernelShapeCallback,(XtPointer)DE_K2_KERNEL);
  CreateOptionButton(subsubform,"deEpanechnikovKernel",(deState.kernelShape == DE_EPANECHNIKOV_KERNEL),KernelShapeCallback,(XtPointer)DE_EPANECHNIKOV_KERNEL);


  XtManageChild(subsubform);
  XtManageChild(subform);
  



  // Simplification Type
  frame = CreateFrame(deForm1, "deSimplificationFrame", "deSimplificationTitle");
  subform = CreateRowColumn(frame,"deSimplificationForm");

  CreateFormEntry(subform, "deSimplificationThreshold", "deSimplificationThresholdTextf",FET_FLOAT, (XtPointer)&deState.simplifyThreshold, &valid, 0);

  CreateLabel(subform,"deSimplificationModeTitle");

  subsubform = CreateRadioBox(subform,"deSimplificationModeForm");
  CreateToggleButton(subsubform,"deSimplificationCompression",(deState.simplifyMode == DE_SIMPLIFY_COMPRESSION),SimplificationModeCallback,(XtPointer)DE_SIMPLIFY_COMPRESSION);
  CreateToggleButton(subsubform,"deSimplificationDecimation",(deState.simplifyMode == DE_SIMPLIFY_DECIMATION),SimplificationModeCallback,(XtPointer)DE_SIMPLIFY_DECIMATION);
  XtManageChild(subsubform);
  
  XtManageChild(subform);



  // Registration
  XtManageChild(deForm1);
  XtManageChild(deForm2);

  
  XtManageChild(deForm);
  
  // Dismiss button callback
  XtAddCallback(deControlPanel, XmNokCallback, DismissCallback, (XtPointer)NULL);

  // Unmanage the Cancel button
  temp = XmMessageBoxGetChild(deControlPanel, XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(temp);

  // Construct the expert mode dialog
  CreateExpertModeControlPanel(deControlPanel);

  ExpertModePBSetState();
}


void ShowDestControlPanel(void)
{
  if (deControlPanel)
    XtManageChild(deControlPanel);
  else
    Error("ShowDensityEstimationControlPanel", "Control panel not created yet.");
}


void HideDestControlPanel(void)
{
  if (deControlPanel)
    XtUnmanageChild(deControlPanel);
  else
    Error("HideDensityEstimationControlPanel", "Control panel not created yet.");
}










