/* interaction.h */

#ifndef _INTERACTION_H_
#define _INTERACTION_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "element.h"

/* for the coupling coefficients and error estimation coefficients: store
 * the coefficient directly if there is only one, if there are more,
 * make an array and store a pointer to it */
typedef union FloatOrPointer {
	float	f;
	float *	p;
} FloatOrPointer;

typedef struct INTERACTION {
	struct ELEMENT	*rcv, *src;		/* receiver and source element */
	FloatOrPointer	K;		/* coupling coefficient(s), stored top to bottom, */
					/* left to right */
	FloatOrPointer	deltaK;		/* used for approximation error estimation over the link */
  /* #ident <<< WMP */
#ifdef WMP_WEIGHTS
  Float *FK;				/* special WMP form factors */
#endif
  /* #ident >>> WMP */
	unsigned char	nrcv, nsrc,	/* nr of basisfunctions on receiver and source */
	        crcv,			/* nr of cubature points on receiver */
	        vis;			/* 255 for full visibility, 0 for full occlusion */
} INTERACTION;

extern INTERACTION *InteractionCreate(struct ELEMENT *rcv, struct ELEMENT *src,
				      FloatOrPointer K,
				      FloatOrPointer deltaK,
				      unsigned char nrcv, 
				      unsigned char nsrc,
				      unsigned char crcv,
				      unsigned char vis
				      /* #ident <<< WMP */
#ifdef WMP_WEIGHTS
				      , Float *FK
#endif
				      /* #ident >>> WMP */
				      );

extern INTERACTION *InteractionDuplicate(INTERACTION *interaction);

extern void InteractionDestroy(INTERACTION *interaction);

#include <stdio.h>
extern void InteractionPrint(FILE *out, INTERACTION *interaction);

extern int GetNumberOfInteractions(void);
extern int GetNumberOfClusterToClusterInteractions(void);
extern int GetNumberOfClusterToSurfaceInteractions(void);
extern int GetNumberOfSurfaceToClusterInteractions(void);
extern int GetNumberOfSurfaceToSurfaceInteractions(void);

#ifdef __cplusplus
}
#endif

#endif /*_INTERACTION_H_*/
