/* interactionlist.h: linear lists of INTERACTIONs */

#ifndef _INTERACTIONLIST_H_
#define _INTERACTIONLIST_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "interaction.h"
#include "List.h"

typedef struct INTERACTIONLIST {
	struct INTERACTION *interaction;
	struct INTERACTIONLIST *next;
} INTERACTIONLIST;

#define InteractionListCreate	(INTERACTIONLIST *)ListCreate

#define InteractionListAdd(interactionlist, interaction)	\
        (INTERACTIONLIST *)ListAdd((LIST *)interactionlist, (void *)interaction)

#define InteractionListCount(interactionlist) \
        ListCount((LIST *)interactionlist)

#define InteractionListGet(interactionlist, index) \
        (INTERACTION *)ListGet((LIST *)interactionlist, index)

#define InteractionListDuplicate(interactionlist) \
        (INTERACTIONLIST *)ListDuplicate((LIST *)interactionlist)

#define InteractionListNext(pinteractionlist) \
        (INTERACTION *)ListNext((LIST **)pinteractionlist)

#define InteractionListMerge(interactionlist1, interactionlist2) \
        (INTERACTIONLIST *)ListMerge((LIST *)interactionlist1, (LIST *)interactionlist2);

#define InteractionListRemove(interactionlist, interaction) \
        (INTERACTIONLIST *)ListRemove((LIST *)interactionlist, (void *)interaction)

#define InteractionListIterate(interactionlist, proc) \
        ListIterate((LIST *)interactionlist, (void (*)(void *))proc)

#define InteractionListIterate1A(interactionlist, proc, data) \
        ListIterate1A((LIST *)interactionlist, (void (*)(void *, void *))proc, (void *)data)

#define InteractionListIterate1B(interactionlist, proc, data) \
        ListIterate1B((LIST *)interactionlist, (void (*)(void *, void *))proc, (void *)data)

#define InteractionListDestroy(interactionlist) \
        ListDestroy((LIST *)interactionlist)

#define InteractionListPrint(fp, interactionlist) \
        InteractionListIterate1B(interactionlist, InteractionPrint, fp);

#define InteractionListIterateRemove(interactionlist, proc) \
	(INTERACTIONLIST *)ListIterateRemove((LIST *)interactionlist, (int (*)(void *))proc)

#define ForAllInteractions(link, linklist) ForAllInList(INTERACTION, link, linklist)

#ifdef __cplusplus
}
#endif

#endif /* _INTERACTIONLIST_H_ */
