/* array.c: arrays */

#include "Array.h"
#include "pools.h"
#include "private.h"

/* creeert een array met gegevens aantal elementen */
ARRAY	*ArrayCreate(int length)
{
	ARRAY *array;

	array = (ARRAY *)Alloc(sizeof(ARRAY));
	array->length = length;
	if (length > 0) 
		array->pel = (void **)Alloc(length * sizeof(void *));
	else
		array->pel = (void **)NULL;
	array->nrels = 0;

	return array;
}

/* geeft een array terug vrij */
void	ArrayDestroy(ARRAY *array)
{
	if (array->length > 0)
		Free((char *)array->pel, array->length * sizeof(void *));
	Free((char *)array, sizeof(ARRAY));
}

/* maakt de array extral elementen groter */
void 	ArrayGrow(ARRAY *array, int extral)
{
	array->pel = (void *)Realloc((char *)array->pel, 
			     array->length * sizeof(void *),
			     extral * sizeof(void *));
	array->length += extral;
}

/* voegt een element toe aan de array, de array wordt groter
 * gemaakt indien nodig. Geeft de index van het toegevoegde element terug */
int	ArrayAdd(ARRAY *array, void *element)
{
/* sanity check */
	if (array->nrels > array->length)
		GdtFatal("ArrayAdd", "more elements in array than possible");

/* array uitbreiden indien nodig */
	if (array->nrels == array->length)
		ArrayGrow(array, 1);

/* element invullen en teller van aantal ingevulde elementen verhogen */
	array->pel[array->nrels] = element;
	array->nrels++;

	return array->nrels-1;
}

/* iterator: voer de gegeven procedure uit op ieder element van de array, 
 * bijvoorbeeld om de elementen te vernietigen vooraleer de array te
 * vernietigen. Het tweede argument is de te herhalen procedure. */
void	ArrayIterate(ARRAY *array, void (*elmethod)(void *))
{
	int i;
	
	for (i=0; i<array->nrels; i++)
		elmethod(array->pel[i]);
}




