/* huraP.h: Het Ultieme Rendering Algoritme (The Ultimate Rendering Algorithm)
 * - "private" data and definitions. Private means: everything that is 
 * not needed in the main directory of the RenderPark program. It's a
 * good place to declare datastructures to be associated with scene
 * patches as well as a global 'state' structure containing all
 * otherwise global variables. */

#ifndef _HURAP_H_
#define _HURAP_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "color.h"

/* data to be associated with each patch */
typedef struct HURA_PATCH_DATA {
  COLOR flux;
} HURA_PATCH_DATA;

/* macros that save a lot of typing work. */
#define FLUX(patch)	((HURA_PATCH_DATA *)(patch->radiance_data))->flux

#include <time.h>

/* groups all global rendering method variables. */
typedef struct HURA_STATE {
  float bla;		/* for demo */
  int bla_is_valid;	/* just in case you are interested in it, I most
			 * often am not. */

  float cpu_secs;	/* for counting computing times */
  clock_t lastclock;	/* " */
  int wake_up;		/* check this value at safe points during the
			 * computations in order to react on user input
			 * if there is any (call CheckForEvents()) */
} HURA_STATE;

extern HURA_STATE hura;	/* one struct containing all global variables. */

extern void CreateHuraControlPanel(void *parent_widget);
extern void UpdateHuraControlPanel(void *parent_widget);
extern void ShowHuraControlPanel(void);
extern void HideHuraControlPanel(void);

#ifdef __cplusplus
}
#endif

#endif /*_HURAP_H_*/
