/* ui_hura.c: Het ultieme rendering algoritme - user interface. This
 * most interesting function in this file is CreateHuraControlPanel(),
 * which is called in ../radiance.c at startup. */

#include <stdio.h>

#include "hura.h"
#include "huraP.h"
#include "ui.h"
#include "uit.h"	/* uit.h contains all the widget creation routines
			 * that we need to build "common" user interfaces. 
			 * It hides many details of Motif and Xt for us. */
#include "error.h"

/* There is a global variable 'hura' of type HURA_STAT that contains all
 * parameters for the rendering method! Through the user interface defined
 * in this file, you might want to change some these values. */

static Widget huraControlPanel = (Widget)NULL;

static void BlaCallback(Widget button, XtPointer client_data, XtPointer call_data)
{
  /* the client data is the data passed to this callback routine at the time
   * of creation of the button, see below. */

  fprintf(stderr, "BLA!!! value = %g (%svalid).\n",
	  hura.bla, hura.bla_is_valid ? "" : "not ");
}

static void CreateBlaBox(Widget frame)
{
  Widget subform;

  /* and a subform inside the frame, so we can put more than one button or
   * other interface things inside the frame. */
  subform = CreateRowColumn(frame, "huraBlaSubForm");

  /* a form entry consisting of a label, saying what the value to be filled
   * in means, and a textfield widget, in which the user can edit the value. */
  /* the 'Boolean *valid' parameter can be NULL if you are not interested in
   * whether or not the test typed in the form entry field is valid or not. */
  CreateFormEntry(subform, "huraBlaLabel", "huraBlaTextField",
		  FET_FLOAT, (XtPointer)&hura.bla, (Boolean *)&hura.bla_is_valid, 0);

  /* a button, third argument is a function to be called when the button
   * is cliked. The last argument is some data we can pass to that routine
   * to identify that this button was pressed, so you can use the same
   * function for e.g. multiple similar buttons. */
  CreatePushButton(subform, "huraBlaButton", BlaCallback, (XtPointer)NULL);

  XtManageChild(subform);
}

void CreateHuraControlPanel(void *parent_widget)
{
  Widget form, frame;

  /* create a dialog widget. This dialog will be popped up when the
   * user selects this algorithm for rendering and clicks the 'Control'
   * button in the 'Rendering' main menu. */
  huraControlPanel = CreateDialog((Widget)parent_widget, "huraControlPanel");

  /* Create a rowcolumn widget inside the dialog. This widget will by
   * default group its subwidgets one on top of the next one in a column.
   * IF you want it in another way, check the XmRowColumn manual page and
   * specify resources in the 'RenderPark' application resource file
   * in the main RenderPark directory. */
  form = CreateRowColumn(huraControlPanel, "huraForm");

  /* label widget with title: the text to appear on this label widget
   * is defined in the RenderPark application resource file ('RenderPark'
   * in the main directory). There should be an entry with something like
   * '*huraTitle.labelString: The Ultimate Rendering Algorithm' */
  CreateLabel(form, "huraTitle");

  /* create a frame grouping a couple of buttons or input fields. */
  frame = CreateFrame(form, "huraBlaFrame", "huraBlaTitle");

  /* create some buttons and input fields in the frame */
  CreateBlaBox(frame);

  /* container widgets need to be managed explicitely (or they wont appear 
   * on the screen: position and size calculations are done when managing
   * the widget. We do this once after all the container widget subwidgets
   * are defined good and well. */
  XtManageChild(form);
}

void ShowHuraControlPanel(void)
{
  if (huraControlPanel)
    XtManageChild(huraControlPanel);
  else
    Error("ShowHuraControlPanel", "Control panel not created yet");
}

void HideHuraControlPanel(void)
{
  if (huraControlPanel)
    XtUnmanageChild(huraControlPanel);
  else
    Error("HideHuraControlPanel", "Control panel not created yet");
}

void UpdateHuraControlPanel(void *parent_widget)
{
  if (huraControlPanel) {
    XtUnmanageChild(huraControlPanel);
    XtDestroyWidget(huraControlPanel);
    CreateHuraControlPanel(parent_widget);
  }
}
