/* ppm.c: handles output to PPM image format files */

#include "ppm.H"

PPMOutputHandle::PPMOutputHandle(FILE *_fp, int w, int h)
{
  ImageOutputHandle::init("PPM", w, h);
  fp = _fp;

  // write header
  if (fp) fprintf(fp, "P6\n%d %d\n255\n", width, height);
}

int PPMOutputHandle::WriteDisplayRGB(unsigned char *rgb)
{
  return fp ? fwrite(rgb, 3, width, fp) : 0;
}


