/* ===========================================================================
    Copyright (c) 1994-2000 K.U.Leuven
    
    This software is provided AS IS, without any express or implied
    warranty.  In no event will the authors or the K.U.Leuven be held
    liable for any damages or loss of profit arising from the use or
    non-fitness for a particular purpose of this software.
    
    See file 0README in the home directory of RenderPark for details about
    copyrights and licensing.
   ===========================================================================
    NAME:       tiff
    TYPE:       c++ header
    PROJECT:    Renderpark - Image output library
    CONTENT:    TIFF output routines
   ===========================================================================
    AUTHORS:    pb      Philippe Bekaert
                jp      Jan Prikryl
   ===========================================================================
    HISTORY:

    09-Jan-00 17:56:30  jp      last modification
    03-Oct-98 15:26:04  pb      released
=========================================================================== */

#ifndef _RPK_TIFF_H_
#define _RPK_TIFF_H_

#ifdef HAVE_LIBTIFF

#include "image.H"
#include "tiffio.h"

// TIFF output handle base class
class TiffOutputHandle : public ImageOutputHandle {
protected:
  TIFF *tif;		// TIFF file handle
  unsigned char *buf;	// scan line data
  int row;		// row number

  void init(char *filename, int w, int h, char *drivername);
  void allocbuf(void);

public:
  TiffOutputHandle();
  ~TiffOutputHandle();
};

// LZW-compressed RGB TIFF output handle
class LZWRGBTiffOutputHandle: public TiffOutputHandle {
public:
  LZWRGBTiffOutputHandle(char *filename, int w, int h);
  int WriteDisplayRGB(unsigned char *rgb);
};

#ifdef HAVE_TIFFINITSGILOG

// High dynamic range (SGILOG compressed LogLuv) TIFF output handle
class SGILogLuvTiffOutputHandle: public TiffOutputHandle {
protected:
  double stonits;	// sample to Nits conversion value

public:
  SGILogLuvTiffOutputHandle(char *filename, int w, int h, float _stonits = 1.);
  int WriteRadianceRGB(float *rgbrad);
  int WriteRadianceXYZ(float *xyzrad);
};

#endif /* HAVE_TIFFINITSGILOG */
#else /* HAVE_LIBTIFF not defined */
/* this file is empty when libtiff is not available */
#endif /* HAVE_LIBTIFF */

#endif /* _RPK_TIFF_H_ */
