/* ===========================================================================
    Copyright (c) 1994-1998 K.U.Leuven
    
    This software is provided AS IS, without any express or implied
    warranty.  In no event will the authors or the K.U.Leuven be held
    liable for any damages or loss of profit arising from the use or
    non-fitness for a particular purpose of this software.
    
    See file 0README in the home directory of RenderPark for details about
    copyrights and licensing.
   ===========================================================================
    NAME:       ui_hierarchy
    TYPE:       c code
    PROJECT:    Renderpark - MC Radiosity
    CONTENT:    User interface methods for hierarchy stuff
   ===========================================================================
    AUTHORS:    jp      Jan Prikryl
   ===========================================================================
    HISTORY:

    14-Jul-99 10:03:50  jp      last modification
    14-Jul-99  8:36:43  jp      created
=========================================================================== */

/* 	$Id: ui_hierarchy.c,v 1.2 2000/10/30 12:48:18 philippe Exp $	 */

#ifndef lint
static const char vcid[] = "$Id: ui_hierarchy.c,v 1.2 2000/10/30 12:48:18 philippe Exp $";
#endif /* lint */

#include "ui.h"
#include "uit.h"
#include <Xm/MessageB.h>
#include "hierarchy.h"
#include "error.h"

/* ---------------------------------------------------------------------------
                                                                 CLUSTERING
--------------------------------------------------------------------------- */
static void 
ClusteringCallback(Widget w,
		   XtPointer client_data,
		   XtPointer call_data)
{
  int set = ((XmToggleButtonCallbackStruct *)call_data)->set;
  if (set)
    hierarchy.clustering = (CLUSTERING_MODE)client_data;
}

void
CreateClusteringMenu(Widget parent)
{
  Widget frame = CreateFrame(parent,
			     "hierClusteringFrame", "hierClusteringTitle");
  Widget toggleBox = CreateRadioBox(frame, "hierClusteringToggleBox");

  CreateToggleButton(toggleBox, "hierNoClusteringButton",
		     hierarchy.clustering == NO_CLUSTERING,
		     ClusteringCallback, (XtPointer)NO_CLUSTERING);

  CreateToggleButton(toggleBox, "hierIsotropicClusteringButton",
		     hierarchy.clustering == ISOTROPIC_CLUSTERING,
		     ClusteringCallback, (XtPointer)ISOTROPIC_CLUSTERING);

  CreateToggleButton(toggleBox, "hierOrientedClusteringButton",
		     hierarchy.clustering == ORIENTED_CLUSTERING,
		     ClusteringCallback, (XtPointer)ORIENTED_CLUSTERING);

  XtManageChild(toggleBox);
}

/* ---------------------------------------------------------------------------
                                                       HIERARCHICAL MESHING
--------------------------------------------------------------------------- */
static void
SetHMeshingCallback(Widget w,
		    XtPointer client_data,
		    XtPointer call_data)
{
  int set = ((XmToggleButtonCallbackStruct *)call_data)->set == XmSET;
  if (hierarchy.do_h_meshing != set && Working()) 
    Warning(NULL, "Interrupt computations first");
  else
    hierarchy.do_h_meshing = set;
}

void
CreateAccuracyBox(Widget parent)
{
  Widget frame = CreateFrame(parent, "hierAccuracyFrame", "hierAccuracyTitle");
  Widget subform = CreateRowColumn(frame, "hierAccuracyForm");

  CreateToggleButton(subform, "hierHMeshingButton", 
		     hierarchy.do_h_meshing ? True : False,
		     SetHMeshingCallback, NULL);

  CreateFormEntry(subform, "hierEpsilon", "hierEpsilonTextf",
		  FET_FLOAT, (XtPointer)&hierarchy.epsilon, NULL, 0);

  CreateFormEntry(subform, "hierMinArea", "hierMinAreaTextf",
		  FET_FLOAT, (XtPointer)&hierarchy.minarea, NULL, 0);

  XtManageChild(subform);
}

#ifdef NEVER
/* ---------------------------------------------------------------------------
                                            PERCEPTUALLY-DRIVEN SUBDIVISION
--------------------------------------------------------------------------- */
static void
SetPdrSubdivideCallback(Widget w,
			XtPointer client_data,
			XtPointer call_data)
{
  int set = ((XmToggleButtonCallbackStruct *)call_data)->set == XmSET;
  if (hierarchy.pdr_subdivide != set && Working()) 
    Warning(NULL, "Interrupt computations first");
  else
    hierarchy.pdr_subdivide = set;
}

void
CreatePdrSubdivideToggleButton(Widget parent)
{
  CreateToggleButton(parent, "hierPdrSubdivideButton", 
		     hierarchy.pdr_subdivide ? True : False,
		     SetPdrSubdivideCallback, NULL);
}

/* ---------------------------------------------------------------------------
                                           IMPORTANCE-BASED MESH REFINEMENT
--------------------------------------------------------------------------- */
static void
SetIdrRefinementCallback(Widget w, 
			 XtPointer client_data,
			 XtPointer call_data)
{
  int set = ((XmToggleButtonCallbackStruct *)call_data)->set == XmSET;
  if (hierarchy.imp_refinement != set && Working()) 
    Warning(NULL, "Interrupt computations first");
  else
    hierarchy.imp_refinement = set;
}

void
CreateImpRefinementToggleButton(Widget parent)
{
  CreateToggleButton(parent, "hierIdrRefinementButton", 
		     hierarchy.imp_refinement ? True : False,
		     SetIdrRefinementCallback, NULL);
}


/* ---------------------------------------------------------------------------
                                            HIERARCHICAL IMPORTANCE STORAGE
--------------------------------------------------------------------------- */
static void
SetIdrHierarchicalCallback(Widget w,
			   XtPointer client_data,
			   XtPointer call_data)
{
  int set = ((XmToggleButtonCallbackStruct *)call_data)->set == XmSET;
  if (hierarchy.do_h_importance != set && Working()) 
    Warning(NULL, "Interrupt computations first");
  else
    hierarchy.do_h_importance = set;
}

void
CreateImpHierarchicalToggleButton(Widget parent)
{
  CreateToggleButton(parent, "hierIdrHierarchicalButton", 
		     hierarchy.do_h_importance ? True : False,
		     SetIdrHierarchicalCallback, NULL);
}
#endif /*NEVER*/

/* ---------------------------------------------------------------------------
                                       PREDEFINED HIERARCHICAL MESHING MENU
--------------------------------------------------------------------------- */
void
CreateHMeshingMenu(Widget parent)
{
  CreateAccuracyBox(parent);
  CreateClusteringMenu(parent);
}
