/* Copyright (c) 1994 Regents of the University of California */

#ifndef lint
static const char SCCSid[] = "@(#)words.c 1.2 5/10/95 LBL";
#endif

/*
 * Routines for recognizing and moving about words in strings.
 */

#include  <ctype.h>

#ifdef  BSD
#define  strchr		index
#endif

#define  NULL		0

extern char  *strchr(const char *, int);


char *
iskip(register char *s)			/* skip integer in string */
                  
{
	while (isspace(*s))
		s++;
	if (*s == '-' || *s == '+')
		s++;
	if (!isdigit(*s))
		return(NULL);
	do
		s++;
	while (isdigit(*s));
	return(s);
}


char *
fskip(register char *s)			/* skip float in string */
                  
{
	register char  *cp;

	while (isspace(*s))
		s++;
	if (*s == '-' || *s == '+')
		s++;
	cp = s;
	while (isdigit(*cp))
		cp++;
	if (*cp == '.') {
		cp++; s++;
		while (isdigit(*cp))
			cp++;
	}
	if (cp == s)
		return(NULL);
	if (*cp == 'e' || *cp == 'E')
		return(iskip(cp+1));
	return(cp);
}


int
isint(char *s)			/* check integer format */
         
{
	register char  *cp;

	cp = iskip(s);
	return(cp != NULL && *cp == '\0');
}


int
isintd(char *s, char *ds)			/* check integer format with delimiter set */
              
{
	register char  *cp;

	cp = iskip(s);
	return(cp != NULL && strchr(ds, *cp) != NULL);
}


int
isflt(char *s)			/* check float format */
         
{
	register char  *cp;

	cp = fskip(s);
	return(cp != NULL && *cp == '\0');
}


int
isfltd(char *s, char *ds)			/* check integer format with delimiter set */
              
{
	register char  *cp;

	cp = fskip(s);
	return(cp != NULL && strchr(ds, *cp) != NULL);
}


int
isname(register char *s)			/* check for legal identifier name */
                  
{
	while (*s == '_')			/* skip leading underscores */
		s++;
	if (!isascii(*s) || !isalpha(*s))	/* start with a letter */
		return(0);
	while (isascii(*++s) && isgraph(*s))	/* all visible characters */
		;
	return(*s == '\0');			/* ending in nul */
}
