/* PhBRML.H: PhBRML material model importer */

#ifndef _PhBRML_H_
#define _PhBRML_H_

#ifndef NO_VRML

#include "matrix.H"
#include "PhBAppearance.H"

#include "material.h"

extern MATERIAL* PhBRMLMaterialCreate(char *name, xrml::PhBAppearance *appearance, 
				      const xrml::Mat4& world2object, const xrml::Mat4& object2world);

// converts PhBRML color representation to 
// RenderPark color representation
// PhBRML uses CIE XYZ representation.
#ifdef RGBCOLORS
#define cvtcol(spectrum, color) xyz_rgb((spectrum).s, (color).spec)
#else
#define cvtcol(spectrum, color) COLORSET((color), (spectrum).s[0], (spectrum).s[1], (spectrum).s[2])
#endif

// converts VRML Vec3 to RenderPark VECTOR
#define cvtvec(vec3, vector) VECTORSET((vector), (vec3).x, (vec3).y, (vec3).z)
#define VECTORTOVEC3(V) Vec3(V.x, V.y, V.z)

#endif /*NO_VRML*/

#endif /*_PhBRML_*/
