/* nied31.c: 31bit 4D base-2 Niederreiter QMC series, ACM TOMS Algorithm 738, dec 94.
 *
 * See also:
 *
 * P. Bratley, B. Fox, H. Niederreiter, "Implementation and Tests of
 *	Low-Discrepancy Sequences", ACM Trans Mod Comp Sim Vol 2 Nr 3, 
 *	July  1992 p195
 *
 * Philippe.Bekaert@cs.kuleuven.ac.be, Thu Oct 23 1997
 */
#include <stdlib.h>
#include <stdio.h>
#include "nied31.h"

static unsigned cj[DIMEN][NBITS] = {
{0x40000000, 0x20000000, 0x10000000, 0x08000000, 
 0x04000000, 0x02000000, 0x01000000, 0x00800000, 
 0x00400000, 0x00200000, 0x00100000, 0x00080000, 
 0x00040000, 0x00020000, 0x00010000, 0x00008000, 
 0x00004000, 0x00002000, 0x00001000, 0x00000800, 
 0x00000400, 0x00000200, 0x00000100, 0x00000080, 
 0x00000040, 0x00000020, 0x00000010, 0x00000008, 
 0x00000004, 0x00000002, 0x00000001}, 
{0x40000000, 0x60000000, 0x50000000, 0x78000000, 
 0x44000000, 0x66000000, 0x55000000, 0x7f800000, 
 0x40400000, 0x60600000, 0x50500000, 0x78780000, 
 0x44440000, 0x66660000, 0x55550000, 0x7fff8000, 
 0x40004000, 0x60006000, 0x50005000, 0x78007800, 
 0x44004400, 0x66006600, 0x55005500, 0x7f807f80, 
 0x40404040, 0x60606060, 0x50505050, 0x78787878, 
 0x44444444, 0x66666666, 0x55555555}, 
{0x60000000, 0x48000000, 0x38000000, 0x7a000000, 
 0x5e000000, 0x36800000, 0x65800000, 0x4b200000, 
 0x3e600000, 0x7ec80000, 0x5db80000, 0x315a0000, 
 0x603e0000, 0x487e8000, 0x385d8000, 0x7a312000, 
 0x5e606000, 0x36c84800, 0x65b83800, 0x4b5a7a00, 
 0x3e3e5e00, 0x7efeb680, 0x5ddde580, 0x31116b20, 
 0x60005e60, 0x480036c8, 0x380065b8, 0x7a004b5a, 
 0x5e003e3e, 0x36807efe, 0x65805ddd}, 
{0x70000000, 0x62000000, 0x46000000, 0x1e000000, 
 0x2c400000, 0x5ac00000, 0x37c00000, 0x7d880000, 
 0x6b580000, 0x44b80000, 0x1b310000, 0x26230000, 
 0x5c470000, 0x38c62000, 0x71c46000, 0x6389e000, 
 0x471ac400, 0x1e7dac00, 0x2cf27c00, 0x5bacd880, 
 0x3719b580, 0x7c7a6b80, 0x6af4d310, 0x45a88230, 
 0x1b580070, 0x26b80062, 0x5d310046, 0x3823001e, 
 0x7007002c, 0x6206205a, 0x46046037}
};

/* the implementation is the same for 31bit and 63bit sequences */
#include "niederreiter.c"
