/* nied63.c: 63bit 4D base-2 Niederreiter QMC series, ACM TOMS Algorithm 738, dec 94.
 *
 * See also:
 *
 * P. Bratley, B. Fox, H. Niederreiter, "Implementation and Tests of
 *	Low-Discrepancy Sequences", ACM Trans Mod Comp Sim Vol 2 Nr 3, 
 *	July  1992 p195
 *
 * Philippe.Bekaert@cs.kuleuven.ac.be, Tue Nov 7 2000
 */

#ifndef NOINT64
/* all this makes no sense if you don't have 64-bit integers */

#include <stdlib.h>
#include <stdio.h>
#include "nied63.h"

static unsigned long long cj[DIMEN][NBITS] = {
{0x4000000000000000uLL, 0x2000000000000000uLL, 0x1000000000000000uLL, 0x0800000000000000uLL, 
 0x0400000000000000uLL, 0x0200000000000000uLL, 0x0100000000000000uLL, 0x0080000000000000uLL, 
 0x0040000000000000uLL, 0x0020000000000000uLL, 0x0010000000000000uLL, 0x0008000000000000uLL, 
 0x0004000000000000uLL, 0x0002000000000000uLL, 0x0001000000000000uLL, 0x0000800000000000uLL, 
 0x0000400000000000uLL, 0x0000200000000000uLL, 0x0000100000000000uLL, 0x0000080000000000uLL, 
 0x0000040000000000uLL, 0x0000020000000000uLL, 0x0000010000000000uLL, 0x0000008000000000uLL, 
 0x0000004000000000uLL, 0x0000002000000000uLL, 0x0000001000000000uLL, 0x0000000800000000uLL, 
 0x0000000400000000uLL, 0x0000000200000000uLL, 0x0000000100000000uLL, 0x0000000080000000uLL, 
 0x0000000040000000uLL, 0x0000000020000000uLL, 0x0000000010000000uLL, 0x0000000008000000uLL, 
 0x0000000004000000uLL, 0x0000000002000000uLL, 0x0000000001000000uLL, 0x0000000000800000uLL, 
 0x0000000000400000uLL, 0x0000000000200000uLL, 0x0000000000100000uLL, 0x0000000000080000uLL, 
 0x0000000000040000uLL, 0x0000000000020000uLL, 0x0000000000010000uLL, 0x0000000000008000uLL, 
 0x0000000000004000uLL, 0x0000000000002000uLL, 0x0000000000001000uLL, 0x0000000000000800uLL, 
 0x0000000000000400uLL, 0x0000000000000200uLL, 0x0000000000000100uLL, 0x0000000000000080uLL, 
 0x0000000000000040uLL, 0x0000000000000020uLL, 0x0000000000000010uLL, 0x0000000000000008uLL, 
 0x0000000000000004uLL, 0x0000000000000002uLL, 0x0000000000000001uLL},
{0x4000000000000000uLL, 0x6000000000000000uLL, 0x5000000000000000uLL, 0x7800000000000000uLL, 
 0x4400000000000000uLL, 0x6600000000000000uLL, 0x5500000000000000uLL, 0x7f80000000000000uLL, 
 0x4040000000000000uLL, 0x6060000000000000uLL, 0x5050000000000000uLL, 0x7878000000000000uLL, 
 0x4444000000000000uLL, 0x6666000000000000uLL, 0x5555000000000000uLL, 0x7fff800000000000uLL, 
 0x4000400000000000uLL, 0x6000600000000000uLL, 0x5000500000000000uLL, 0x7800780000000000uLL, 
 0x4400440000000000uLL, 0x6600660000000000uLL, 0x5500550000000000uLL, 0x7f807f8000000000uLL, 
 0x4040404000000000uLL, 0x6060606000000000uLL, 0x5050505000000000uLL, 0x7878787800000000uLL, 
 0x4444444400000000uLL, 0x6666666600000000uLL, 0x5555555500000000uLL, 0x7fffffff80000000uLL, 
 0x4000000040000000uLL, 0x6000000060000000uLL, 0x5000000050000000uLL, 0x7800000078000000uLL, 
 0x4400000044000000uLL, 0x6600000066000000uLL, 0x5500000055000000uLL, 0x7f8000007f800000uLL, 
 0x4040000040400000uLL, 0x6060000060600000uLL, 0x5050000050500000uLL, 0x7878000078780000uLL, 
 0x4444000044440000uLL, 0x6666000066660000uLL, 0x5555000055550000uLL, 0x7fff80007fff8000uLL, 
 0x4000400040004000uLL, 0x6000600060006000uLL, 0x5000500050005000uLL, 0x7800780078007800uLL, 
 0x4400440044004400uLL, 0x6600660066006600uLL, 0x5500550055005500uLL, 0x7f807f807f807f80uLL, 
 0x4040404040404040uLL, 0x6060606060606060uLL, 0x5050505050505050uLL, 0x7878787878787878uLL, 
 0x4444444444444444uLL, 0x6666666666666666uLL, 0x5555555555555555uLL},
{0x6000000000000000uLL, 0x4800000000000000uLL, 0x3800000000000000uLL, 0x7a00000000000000uLL, 
 0x5e00000000000000uLL, 0x3680000000000000uLL, 0x6580000000000000uLL, 0x4b20000000000000uLL, 
 0x3e60000000000000uLL, 0x7ec8000000000000uLL, 0x5db8000000000000uLL, 0x315a000000000000uLL, 
 0x603e000000000000uLL, 0x487e800000000000uLL, 0x385d800000000000uLL, 0x7a31200000000000uLL, 
 0x5e60600000000000uLL, 0x36c8480000000000uLL, 0x65b8380000000000uLL, 0x4b5a7a0000000000uLL, 
 0x3e3e5e0000000000uLL, 0x7efeb68000000000uLL, 0x5ddde58000000000uLL, 0x31116b2000000000uLL, 
 0x60005e6000000000uLL, 0x480036c800000000uLL, 0x380065b800000000uLL, 0x7a004b5a00000000uLL, 
 0x5e003e3e00000000uLL, 0x36807efe80000000uLL, 0x65805ddd80000000uLL, 0x4b20311120000000uLL, 
 0x3e60600060000000uLL, 0x7ec8480048000000uLL, 0x5db8380038000000uLL, 0x315a7a007a000000uLL, 
 0x603e5e005e000000uLL, 0x487eb68036800000uLL, 0x385de58065800000uLL, 0x7a316b204b200000uLL, 
 0x5e605e603e600000uLL, 0x36c836c87ec80000uLL, 0x65b865b85db80000uLL, 0x4b5a4b5a315a0000uLL, 
 0x3e3e3e3e603e0000uLL, 0x7efefefec87e8000uLL, 0x5dddddddb85d8000uLL, 0x311111115a312000uLL, 
 0x600000003e606000uLL, 0x480000007ec84800uLL, 0x380000005db83800uLL, 0x7a000000315a7a00uLL, 
 0x5e000000603e5e00uLL, 0x36800000487eb680uLL, 0x65800000385de580uLL, 0x4b2000007a316b20uLL, 
 0x3e6000005e605e60uLL, 0x7ec8000036c836c8uLL, 0x5db8000065b865b8uLL, 0x315a00004b5a4b5auLL, 
 0x603e00003e3e3e3euLL, 0x487e80007efefefeuLL, 0x385d80005ddddddduLL},
{0x7000000000000000uLL, 0x6200000000000000uLL, 0x4600000000000000uLL, 0x1e00000000000000uLL, 
 0x2c40000000000000uLL, 0x5ac0000000000000uLL, 0x37c0000000000000uLL, 0x7d88000000000000uLL, 
 0x6b58000000000000uLL, 0x44b8000000000000uLL, 0x1b31000000000000uLL, 0x2623000000000000uLL, 
 0x5c47000000000000uLL, 0x38c6200000000000uLL, 0x71c4600000000000uLL, 0x6389e00000000000uLL, 
 0x471ac40000000000uLL, 0x1e7dac0000000000uLL, 0x2cf27c0000000000uLL, 0x5bacd88000000000uLL, 
 0x3719b58000000000uLL, 0x7c7a6b8000000000uLL, 0x6af4d31000000000uLL, 0x45a8823000000000uLL, 
 0x1b58007000000000uLL, 0x26b8006200000000uLL, 0x5d31004600000000uLL, 0x3823001e00000000uLL, 
 0x7007002c40000000uLL, 0x6206205ac0000000uLL, 0x46046037c0000000uLL, 0x1e01e07d88000000uLL, 
 0x2c42c46b58000000uLL, 0x5ac5ac44b8000000uLL, 0x37c37c1b31000000uLL, 0x7d8fd8a623000000uLL, 
 0x6b5eb5dc47000000uLL, 0x44bc4bb8c6200000uLL, 0x1b30b361c4600000uLL, 0x2621625389e00000uLL, 
 0x5c42c4371ac40000uLL, 0x38c5ac7c7dac0000uLL, 0x71c37c6af27c0000uLL, 0x638fd8c5acd88000uLL, 
 0x471eb59b59b58000uLL, 0x1e7c4ba6ba6b8000uLL, 0x2cf0b34d34d31000uLL, 0x5ba9620820823000uLL, 
 0x371ac40000007000uLL, 0x7c7dac0000006200uLL, 0x6af27c0000004600uLL, 0x45acd88000001e00uLL, 
 0x1b59b58000002c40uLL, 0x26ba6b8000005ac0uLL, 0x5d34d310000037c0uLL, 0x3820823000007d88uLL, 
 0x7000007000006b58uLL, 0x62000062000044b8uLL, 0x4600004600001b31uLL, 0x1e00001e00002623uLL, 
 0x2c40002c40005c47uLL, 0x5ac0005ac00038c6uLL, 0x37c00037c00071c4uLL}
};

/* the implementation is the same for 31bit and 63bit sequences */
#include "niederreiter.c"

#endif /*NOINT64*/
