/* bidiroptions.C: implements option handling for bidirectional
   path tracing */

#include "Boolean.h"
#include "options.h"
#include "bidiroptions.H"

/**************************************************************/
/* User interface links */

void BidirPathDefaults(void)
{
  bidir.basecfg.samplesPerPixel = 1;
  bidir.basecfg.progressiveTracing = TRUE;

  bidir.basecfg.minimumPathDepth = 2;
  bidir.basecfg.maximumPathDepth = 7;
  bidir.basecfg.maximumEyePathDepth = 7;
  bidir.basecfg.maximumLightPathDepth = 7;
  bidir.basecfg.sampleImportantLights = TRUE;

  bidir.basecfg.useSpars = FALSE;
  bidir.basecfg.doLe = TRUE;
  bidir.basecfg.doLD = FALSE;
  bidir.basecfg.doLI = FALSE;

  // Weighted not in UI
  bidir.basecfg.doWeighted = FALSE;

  sprintf(bidir.basecfg.leRegExp, "(LX)(X)*(EX)");
  sprintf(bidir.basecfg.ldRegExp, "(LX)(G|S)(X)*(EX),(LX)(EX)");
  sprintf(bidir.basecfg.liRegExp, "(LX)(G|S)(X)*(EX),(LX)(EX)");
  sprintf(bidir.basecfg.wleRegExp, "(LX)(DR)(X)*(EX)");
  sprintf(bidir.basecfg.wldRegExp, "(LX)(X)*(EX)");

  // -- Not in UI yet
  bidir.saveSubsequentImages = FALSE;
  bidir.basecfg.eliminateSpikes = FALSE;
  bidir.basecfg.doDensityEstimation = FALSE;

  //sprintf(bidir.baseFilename, "");
  bidir.baseFilename[0] = '\0';
}

MakeNStringTypeStruct(RegExpStringType, MAX_REGEXP_SIZE);
#define TregexpString (&RegExpStringType)

static CMDLINEOPTDESC bidirOptions[] = {
  {"-bidir-samples-per-pixel", 8,	Tint,	&bidir.basecfg.samplesPerPixel,	DEFAULT_ACTION,
   "-bidir-samples-per-pixel <number> : eye-rays per pixel"},
  {"-bidir-no-progressive", 11,	Tsetfalse, &bidir.basecfg.progressiveTracing, DEFAULT_ACTION,
   "-bidir-no-progressive          \t: don't do progressive image refinement"},
  {"-bidir-max-eye-path-length", 12,	Tint,	&bidir.basecfg.maximumEyePathDepth,	DEFAULT_ACTION,
   "-bidir-max-eye-path-length <number>: maximum eye path length"},
  {"-bidir-max-light-path-length", 12,	Tint,	&bidir.basecfg.maximumLightPathDepth,	DEFAULT_ACTION,
   "-bidir-max-light-path-length <number>: maximum light path length"},
  {"-bidir-max-path-length", 12,	Tint,	&bidir.basecfg.maximumPathDepth,	DEFAULT_ACTION,
   "-bidir-max-path-length <number>\t: maximum combined path length"},
  {"-bidir-min-path-length", 12,	Tint,	&bidir.basecfg.minimumPathDepth,	DEFAULT_ACTION,
   "-bidir-min-path-length <number>\t: minimum path length before russian roulette"},
  {"-bidir-no-light-importance", 11, Tsetfalse, &bidir.basecfg.sampleImportantLights, DEFAULT_ACTION,
   "-bidir-no-light-importance     \t: sample lights based on power, ignoring their importance"},
  {"-bidir-use-regexp", 12, Tsettrue,	&bidir.basecfg.useSpars, DEFAULT_ACTION,
   "-bidir-use-regexp\t: use regular expressions for path evaluation"},
  {"-bidir-use-emitted", 12, Tbool,	&bidir.basecfg.doLe, DEFAULT_ACTION,
   "-bidir-use-emitted <yes|no>\t: use reg exp for emitted radiance"},
  {"-bidir-rexp-emitted", 13, TregexpString,	bidir.basecfg.leRegExp, DEFAULT_ACTION,
   "-bidir-rexp-emitted <string>\t: reg exp for emitted radiance"},
  {"-bidir-reg-direct", 12, Tbool,	&bidir.basecfg.doLD, DEFAULT_ACTION,
   "-bidir-reg-direct <yes|no>\t: use reg exp for stored direct illumination (galerkin!)"},
  {"-bidir-rexp-direct", 13, TregexpString,	bidir.basecfg.ldRegExp, DEFAULT_ACTION,
   "-bidir-rexp-direct <string>\t: reg exp for stored direct illumination"},
  {"-bidir-reg-indirect", 12, Tbool,	&bidir.basecfg.doLI, DEFAULT_ACTION,
   "-bidir-reg-indirect <yes|no>\t: use reg exp for stored indirect illumination (galerkin!)"},
  {"-bidir-rexp-indirect", 13, TregexpString,	bidir.basecfg.liRegExp, DEFAULT_ACTION,
   "-bidir-rexp-indirect <string>\t: reg exp for stored indirect illumination"},
  {NULL	, 		0,	TYPELESS, NULL, 		DEFAULT_ACTION,
   NULL}
};

void BidirPathParseOptions(int *argc, char **argv)
{
  ParseOptions(bidirOptions, argc, argv);
}

void BidirPathPrintOptions(FILE *fp)
{
  fprintf(fp, "\nBidirectional Path Tracing options:\n");
  PrintOptions(fp, bidirOptions);
}

