/* sgl.h: Small Graphics Library */

#ifndef _SGL_H_
#define _SGL_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "sgl_context.h"

/* creates, destroys an SGL rendering context. sglOpen() also makes the new context
 * the current context. */
extern SGL_CONTEXT *sglOpen(int width, int height);
extern void sglClose(SGL_CONTEXT *context);

/* makes the specified context current, returns the previous current context */
extern SGL_CONTEXT *sglMakeCurrent(SGL_CONTEXT *context);

/* returns current sgl renderer */
#define sglGetCurrent()	(current_sgl_context)

/* all the following operate on the current SGL context and behave very similar as
 * the corresponding functions in OpenGL. */
extern void sglClearFrameBuffer(SGL_PIXEL backgroundcol);
extern void sglClearZBuffer(SGL_ZVAL defzval);
extern void sglClear(SGL_PIXEL backgroundcol, SGL_ZVAL defzval);
extern void sglDepthTesting(SGL_BOOLEAN on);
extern void sglClipping(SGL_BOOLEAN on);
extern void sglPushMatrix(void);
extern void sglPopMatrix(void);
extern void sglLoadMatrix(TRANSFORM xf);
extern void sglMultMatrix(TRANSFORM xf);
extern void sglSetColor(SGL_PIXEL col);
extern void sglViewport(int x, int y, int width, int height);
extern void sglDepthRange(double near, double far);
extern void sglPolygon(int nrverts, VECTOR *verts);

/* returns pixel at position (x,y) */
#define sglGetPixel(x, y) (current_sgl_context->fbuf[(current_sgl_context->height-1-y) * current_sgl_context->width + x])

#ifdef __cplusplus
}
#endif

#endif /*_SGL_H_*/
