/* compound.c */

#include <stdio.h>
#include <stdlib.h>
#include "compound.h"
#include "error.h"
#include "pools.h"
#include "geom.h"

int nrcompounds = 0;

/* "creates" a COMPOUND from a list of GEOMetries */
COMPOUND *CompoundCreate(GEOMLIST *geomlist)
{
  nrcompounds++;
  return geomlist;
}

/* This method will compute a bounding box for a GEOMetry. The bounding box
 * is filled in in boundingbox and a pointer to the filled in boundingbox returned. */
static float *CompoundBounds(COMPOUND *obj, float *boundingbox)
{
  return GeomListBounds(obj, boundingbox);
}

/* this method will destroy the GEOMetry and it's children GEOMetries if any */
static void   CompoundDestroy(COMPOUND *obj)
{
  GeomListIterate(obj, GeomDestroy);
  GeomListDestroy(obj);
  nrcompounds--;
}

/* this method will print the GEOMetry to the file out */
void   CompoundPrint(FILE *out, COMPOUND *obj)
{
  fprintf(out, "compound\n");
  GeomListIterate1B(obj, GeomPrint, out);  
  fprintf(out, "end of compound\n");
}

/* returns the list of children GEOMetries if the GEOM is an aggregate */
GEOMLIST *CompoundPrimitives(COMPOUND *obj)
{
  return obj;
}

struct HITREC *CompoundDiscretisationIntersect(COMPOUND *obj, RAY *ray, float mindist, float *maxdist, int hitflags, HITREC *hitstore)
{
  return GeomListDiscretisationIntersect(obj, ray, mindist, maxdist, hitflags, hitstore);
}

struct HITLIST *CompoundAllDiscretisationIntersections(HITLIST *hits, COMPOUND *obj, RAY *ray, float mindist, float maxdist, int hitflags)
{
  return GeomListAllDiscretisationIntersections(hits, obj, ray, mindist, maxdist, hitflags);
}

/* a struct containing pointers to the methods for operating on COMPOUNDs, as 
 * declared in geom_methods.h. */
GEOM_METHODS compoundMethods = {
  (float *(*)(void *, float *))CompoundBounds,
  (void (*)(void *))CompoundDestroy,
  (void (*)(FILE *, void *))CompoundPrint,
  (GEOMLIST *(*)(void *))CompoundPrimitives,
  (PATCHLIST *(*)(void *))NULL,
  (HITREC *(*)(void *, RAY *, float, float *, int, HITREC *))CompoundDiscretisationIntersect,
  (HITLIST *(*)(HITLIST *, void *, RAY *, float, float, int))CompoundAllDiscretisationIntersections,
  (void *(*)(void *))NULL
};


