/* ===========================================================================
    Copyright (c) 1994-2000 K.U.Leuven
    
    This software is provided AS IS, without any express or implied
    warranty.  In no event will the authors or the K.U.Leuven be held
    liable for any damages or loss of profit arising from the use or
    non-fitness for a particular purpose of this software.
    
    See file 0README in the home directory of RenderPark for details about
    copyrights and licensing.
   ===========================================================================
    NAME:       luv
    TYPE:       c header
    CONTENT:    CIE L*u*v* color space
   ===========================================================================
    AUTHORS:    jp      Jan Prikryl
                pb      Philippe Bekaert
   ===========================================================================
    HISTORY:

    09-Jan-00 17:56:30  jp      last modification
    30-Sep-98 19:21:07  jp      created
=========================================================================== */

#ifndef _RPK_LUV_H_
#define _RPK_LUV_H_

/* CIE L*u*v* colour triplet. */
typedef struct LUV {
  float L, u, v;
} LUV;

/* Macro to print a LUV triplet; it's a macro, not a function,
 * therefore I am using capitals */
#define LUV_PRINT(_f, _c) \
	fprintf(_f, "Luv(%8g,%8g,%8g)", (_c).L, (_c).u, (_c).v)

/* CIE color difference formula: Eucledian distance of two LUV colors */
#define LUV_DIFF(_c1, _c2) \
	sqrt(((_c1).L-(_c2).L)*((_c1).L-(_c2).L) + \
	     ((_c1).u-(_c2).u)*((_c1).u-(_c2).u) + \
	     ((_c1).v-(_c2).v)*((_c1).v-(_c2).v))

/* Visibility threshold ... some people claim it's 2% on the luminance
 * scale, therefore it shall be 2 for LUV colour where L goes from 0
 * to 100. I am not sure that this is the correct approach though. */
#define LUV_VISIBILITY_THRESHOLD 2.0

#endif /*_RPK_LUV_H_*/
