/* monitor.c: debugging aid: maintains a list of patches to be "monitored" */

#include "patchlist.h"
#include "monitor.h"
#include "error.h"

static PATCHLIST *monitoredPatches = (PATCHLIST *)NULL;

/* Initializes the list of patches to be monitored. */
void MonitorInit(void)
{
  PatchListDestroy(monitoredPatches);
  monitoredPatches = (PATCHLIST *)NULL;
}

/* returns TRUE if the given patch is being monitored and FALSE if not. */
int Monitored(PATCH *patch)
{
  PATCHLIST *pl;
  for (pl = monitoredPatches; pl; pl = pl->next)
    if (pl->patch == patch)
      return TRUE;
  return FALSE;
}

/* adds the patch to the list of patches to be monitored. */
void MonitorAdd(PATCH *patch)
{
  if (!Monitored(patch)) 
    monitoredPatches = PatchListAdd(monitoredPatches, patch);
  else
    Warning(NULL, "Patch %d is already being monitored", patch->id);
}

/* removes the patch from the list of patches being monitored. */
void MonitorRemove(PATCH *patch)
{
  if (Monitored(patch))
    monitoredPatches = PatchListRemove(monitoredPatches, patch);
  else
    Warning(NULL, "Patch %d was not being monitored", patch->id);
}

