/* ===========================================================================
    Copyright (c) 1994-1998 K.U.Leuven
    
    This software is provided AS IS, without any express or implied
    warranty.  In no event will the authors or the K.U.Leuven be held
    liable for any damages or loss of profit arising from the use or
    non-fitness for a particular purpose of this software.
    
    See file 0README in the home directory of RenderPark for details about
    copyrights and licensing.
   ===========================================================================
    NAME:       rpkint64
    TYPE:       c header
    PROJECT:    Renderpark - MC Radiosity
    CONTENT:    64 bit long integer value
   ===========================================================================
    AUTHORS:    jp      Jan Prikryl
   ===========================================================================
    HISTORY:

    17-Jan-99 22:01:00  jp      last modification
    17-Jan-99 21:47:32  jp      GNU C check, SGI untested.
    17-Jan-99 21:47:32  jp      created
=========================================================================== */

#ifndef _RPKINT64_INCLUDED_
#define _RPKINT64_INCLUDED_

/* GNU C defines `long long int' - check, whether the compiler is GNU
   and if so, use this extension.  */

#ifdef __GNUC__

typedef long long int rpkint64;

#else

/* SGI is internally 64bit for R4000 and higher - we will use their
   speical 64bit arithmetic routines. */

#ifdef SGI

#include <inttypes.h>
typedef _int64 rpkint64;

#else

/* Make it still usable for simple tasks. */

typedef int rpkint64;

#endif /* SGI */
#endif /* __GNUC__ */

#endif /* _RPKINT64_INCLUDED_ */






