/* scene.c: global variables representing the current scene */
#include "scene.h"

/* the current scene */
GEOMLIST *World = (GEOMLIST *)NULL;

/* the list of all materials present in the current scene */
MATERIALLIST *MaterialLib = (MATERIALLIST *)NULL;

/* current background for the scene */
BACKGROUND *Background = (BACKGROUND *)NULL;

/* the list of all PATCHes in the current scene. */
PATCHLIST *Patches = (PATCHLIST *)NULL;

/* the list of all patches on luminaires */
PATCHLIST *LightSourcePatches = (PATCHLIST *)NULL;

/* A hierarchical model of the discretized world, automaticlly created
 * from the list of patches 'Patches' when reading a scene. */
GEOMLIST *ClusteredWorld = (GEOMLIST *)NULL;
GEOM *ClusteredWorldGeom = (GEOM *)NULL;

/* voxel grid containing the whole scene, for ray tracing acceleration */
GRID *WorldGrid = (GRID *)NULL;
