/* softids.h: software ID rendering: because hardware ID rendering is tricky 
 * due to frame buffer formats, .... */

#ifndef _RPK_SOFTIDS_H_
#define _RPK_SOFTIDS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "sgl.h"
#include "patch.h"

/* sets up a software rendering context and initialises transforms and 
 * viewport for the current view. The new renderer is made current. */
extern SGL_CONTEXT *SetupSoftFrameBuffer(void);

/* renders all Patches in the current sgl renderer. PatchPixel returns
 * and SGL_PIXEL value for a given PATCH */
extern void SoftRenderPatches(SGL_PIXEL (*PatchPixel)(PATCH *));

/* software ID rendering */
extern unsigned long *SoftRenderIds(long *x, long *y);

#ifdef __cplusplus
}
#endif

#endif /*_RPJ_SOFTIDS_H_*/
