/* ui_help.c: help submenu */

#include <stdlib.h>

#include "ui.h"
#include "uit.h"
#include "defaults.h"

/* creates the Help dialog */
static Widget CreateHelpDialog(Widget parent, char *name)
{
  Widget helpBox = CreateDialog(parent, name);
  UnmanageMessageBoxChild(helpBox, XmDIALOG_CANCEL_BUTTON);

  /* scrolled window around the help label */
  CreateScrolledWindow(helpBox, "helpScrollW", NULL, "helpLabel");
  return helpBox;
}

static void HomeCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
  char browsecmd[200];
  sprintf(browsecmd, WEBBROWSER, RPKHOME);
  fprintf(stderr, "Executing: %s ...\n", browsecmd);
  system(browsecmd);
}

static void DocCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
  char browsecmd[200];
  sprintf(browsecmd, WEBBROWSER, RPKHTMLDOC);
  fprintf(stderr, "Executing: %s ...\n", browsecmd);
  system(browsecmd);
}

/* creates the Help menu */
void CreateHelpMenu(Widget parent)
{
  Widget helpMenu = CreateHelpSubMenu(parent, "helpButton", "helpMenu");
  CreateCascadeDialog(helpMenu, "quickHelpButton", CreateHelpDialog, "helpBox", DEFAULT_CALLBACK, NULL);
  CreatePushButton(helpMenu, "homeButton", HomeCallback, NULL);
  CreatePushButton(helpMenu, "docButton", DocCallback, NULL);
}

