/* vectorlist.c */

#include "vectorlist.h"

/* This routine looks up a vector in a list of vectors. If a vector
 * being equal to the given vector is found in the list,
 * a popointer to the vector in the list is returned. If no such vector is
 * in the list, (VECTOR *)NULL is returned. */
VECTOR *VectorListFind(VECTORLIST *vl, VECTOR *vector)
{
  VECTOR *v;

  while ((v = VectorListNext(&vl))) {
    float eps = VECTORTOLERANCE(*v) + VECTORTOLERANCE(*vector);
    if (VECTOREQUAL(*v, *vector, eps))
      return v;
  }

  return (VECTOR *)NULL;
}
