/* vertexlist.c */

#include "vertexlist.h"
#include "vertex.h"

VERTEX *VertexListFind(VERTEXLIST *vl, VECTOR *point, VECTOR *norm, VECTOR *texCoord)
{
  VERTEX ref;
  ref.point = point;
  ref.normal = norm;
  ref.texCoord = texCoord;	/* other fields are not relevant when comparing vertices. */

  ForAllVertices(v, vl) {
    if (VertexCompare(v, &ref) == XYZ_EQUAL)
      return v;
  } EndForAll;

  return (VERTEX *)NULL;
}

