/* writevrml.h: saves the result of a radiosity computation as a VRML file. */

#ifndef _WRITE_VRML_H_
#define _WRITE_VRML_H_

#include <stdio.h>

/* Default method for saving VRML models (if the current radiance method
 * doesn't have its own one. */
extern void WriteVRML(FILE *fp);

/* Can also be used by radiance-method specific VRML savers. See
 * WriteVRML.c for how they are to be used and what they do. */
extern void WriteVRMLHeader(FILE *fp);
extern void WriteVRMLTrailer(FILE *fp);

#include "camera.h"
#include "transform.h"
extern TRANSFORM VRMLModelTransform(VECTOR *model_rotaxis, float *model_rotangle);
extern void WriteVRMLViewPoint(FILE *fp, TRANSFORM model_xf, CAMERA *cam, char *vpname);
extern void WriteVRMLViewPoints(FILE *fp, TRANSFORM model_xf);

#endif /*_WRITE_VRML_H_*/
