// cso_exporter: VRML'97 utf8 encoding exporter

#ifndef _CSO_EXPORTER_H_
#define _CSO_EXPORTER_H_

#include "../exporter.H"

namespace cso {
  using namespace xrml;

class exporter: public xrml::exporter {
  int id;
  char *prefix;

  int  save_id(const SFNode*);
  bool saved_already(const SFNode*);
  void set_save_id(class SFNode*);
  void save(class SFNode*);
  char *unique_nameId(class SFNode*);
  void save_value(const SFBool& val);
  void save_value(const SFString& val);
  void save_value(const SFInt32& val);
  void save_value(const SFFloat& val);
  void save_value(const SFTime& val);
  void save_value(const SFVec2f& val);
  void save_value(const SFVec3f& val);
  void save_value(const SFColor& val);
  void save_value(const SFRotation& val);
  void save_value(const SFImage& val);
  void save_value(const SFNode* val);
  void save_value(const char* Id, const fieldValue& value, int index);
  void save_link(class link* ref, int index);
  void save_field(class field* field, int index);
  void save_field_or_link(class interfaceMember* ifm, int index);
  void save_members(class SFNode* node);
  void save_children_nodes(class field* field);
  void save_children_nodes(class SFNode* node);
  const char* memberkindname(class interfaceMember* ifm);
  const char* membertypename(class interfaceMember* ifm);
  void save_proto_interfaceMember(class interfaceMember* ifm);
  void save_proto_interface(class Proto* proto);
  void save_proto_implementation(class Proto* proto);
  void save_protodef(class Proto* proto);
  void save_context(const MFNode* sceneGraph, const protoTable& protos, const namedNodeTable& namedNodes, char* prefix);
  void save_route(class SFNode* srcNode, int srcIndex, class route* route);
  void save_routes(class SFNode* srcNode, int srcIndex, class routing_table* rtable);
  void save_routes(class SFNode* node);
  void save_routes(const MFNode& nodes);
  void save_children_routes(class  field* field);
  void clear_data(class field* field);
  void clear_data(class SFNode* node);
  void clear_data(const MFNode& nodes);
  void clear_data(class Proto* proto);
  void clear_data(class world* world);

public:
  exporter(class file* fh =0)
  {
    xrml::exporter::init(fh);
  }

  void save(class world* world);
};

}   // namespace cso

#endif /* _CSO_EXPORTER_H_ */
