// importer.C: import filter template

/*
   include all necessary include files
*/
#include <dlfcn.h>
#include "importer.H"

namespace cso {
  using namespace xrml;  // so we can omit the xrml:: name space prefix

xrml::importer* cso::importer::instantiate(class xrml::file* file_handle)
{
  return new cso::importer;
}

bool importer::parse(class world* world, char **strpool)
{
  // open the shared object
  void* handle = dlopen(world->file->name, RTLD_NOW);
  if (!handle) {
    Error(NULL, "%s", dlerror());
    return false;
  }

  // find the address of the routine called "import"
  void (*import)(void*, char**) = (void (*)(void*, char**))dlsym(handle, "import");
  //  void (*import)(xrml::world*, char**) = (void (*)(xrml::world*, char**))dlsym(handle, "import__FPQ24xrml5worldPPc");
  char *error = dlerror();
  if (error) {
    Error(NULL, "%s", error);
    return false;
  }

  // call this routine, which builds the scene graph etc...
  import(world, strpool);

  // de-allocate the shared library and return
  dlclose(handle);
  return true;
}

} // namespace cso
