// importer.H: import filter template

#ifndef _CSO_IMPORTER_H_
#define _CSO_IMPORTER_H_

#include "../importer.H"

// put the filters in this directory in their own name space
namespace cso {

// our importer shall be a child class of xrml::importer
class importer: public xrml::importer {
protected:
  // put all members for internal use here

public:
  // implement the virtual-declared members in xrml::importer:

  // This member function checks whether or not the importer class is
  // appropriate for parsing the specified file. If not, it returns
  // a null pointer. If appropriate, this functions returns a new
  // instance of the importer class.
  // If file_handle is null, just return a new importer object
  // of this class.
  xrml::importer* instantiate(class xrml::file* file_handle =0);

  // After instantiating an importer for a file, this member functions is
  // called from xrml::world->parse(). It parses the file desribed by the file
  // handle xrml::world->file (same handle as used for the instantiate() call).
  // The resulting scene graph is APPENDED to the following members of
  // the world object:
  // . sceneGraph (MFNode*)
  // . namedNodes (namedNodeTable) : table of named nodes (if any)
  // . protos (protoTable) : table of PROTO and EXTERNPROTO defined, if any.
  // After parsing, strpool shall point to a pool of strings read from 
  // the file (if applicable).
  bool parse(class xrml::world* world, char **strpool);
};

} // end namespace cso

#endif /* _CSO_IMPORTER_H_ */
