// mgf export filter.

#include "world.H"
#include "mgf/exporter.H"
#include "mgf/renderer.H"

namespace mgf {
  exporter::exporter(char* progname, bool rgb_vertex_colors)
  {
    exporter::progname = progname;
    exporter::rgb_vertex_colors = rgb_vertex_colors;
  }

  void exporter::init(class xrml::file* file_handle)
  {
    // save private copy of the file handle
    fh = file_handle;
  }

  void exporter::save(class xrml::world* wrl)
  {
    // temporarily replace the current renderer by a
    // MGF conversion renderer
    mgf::renderer* mgf_renderer = new mgf::renderer(fh, progname, rgb_vertex_colors);
    xrml::renderer* old_renderer = wrl->set_renderer(mgf_renderer);

    // render the current frame
    wrl->render();

    // re-install the original renderer and delete the 
    // MGF conversion renderer
    wrl->set_renderer(old_renderer);
    delete mgf_renderer;
  }
}
