/* renderer.H: A "renderer" object class to export MGF files */

#ifndef _MGF_RENDERER_H_
#define _MGF_RENDERER_H_

#include "../renderer.H"
#include "../Stack.H"

namespace mgf {
  using namespace xrml;

class renderer: public xrml::renderer {
private:
  class file* fh;

  int matlevel;		// material nesting level
  int ocount;		// 'o' context count
  stack<bool> xf_stack;	// false or true depending on wheter something was done or not.
  array<int> vidx;	// indices of vertices in face
  Vec3 current_normal;	// current face/vertex normal
  SFColor current_color;// current face/vertex color
  bool reverse_vertex_order; // used when writing face vertices
  bool color_updated;	// per-face or per-vertex color has changed
  bool orig_material;	// current material has not yet suffered updates
  char *current_matname;// current material name
  int current_sidedness;// current material sidedness

  void convert_material(char *matname, struct Material *mat);

public:
  bool rgb_vertex_colors;
  char *progname;

  // general
  void begin_frame(world*);
  void end_frame(world*);
  
  // grouping and transforms
  void begin_Grouping(Grouping *);
  void end_Grouping(Grouping *);
  void begin_Transforming(Transforming *);
  void end_Transforming(Transforming *);

  // shape
  void begin_Shape(Shape *);

  // materials
  void begin_Material(Material *);
  void end_Material(Material *);

  // geometries
  void geometry(Geometry *);	// calls back default handler
  void box(Box *);
  void cone(Cone *);
  void cylinder(Cylinder *);
  void sphere(Sphere *);

  // called by the default geometry handler renderer::geometry() 
  void begin_faces(Geometry *);
  void begin_face(int, int);
  void face_normal(int, const SFVec3f&);
  void face_color(int, const SFColor&);
  void vertex_coord(int, const SFVec3f&);
  void vertex_texCoord(int, const SFVec2f&);
  void vertex_normal(int, const SFVec3f&);
  void vertex_color(int, const SFColor&);
  void end_face(int, int);
  void end_faces(Geometry *);

  renderer(class file* file_handle, char* progname =0, bool rgb_vertex_colors =false);
  ~renderer();
};

}  // end namespace mgf
#endif /*_MGF_RENDERER_H_*/
